import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';

import * as extracted from './social_profile.js';
import {link} from '../social_block.js';

const socialNames = {
    fb: 'Facebook',
    mr: 'Mail.ru',
    vk: 'Vkontakte',
    gg: 'Google',
    tw: 'Twitter',
    ok: 'Odnoklassniki',
    dz: 'Deezer',
    ig: 'Instagram',
    lf: 'Last.fm',
    ya: i18n('Profile2.taxi'),
    apl: 'Apple ID',
    esia: i18n('_AUTH_.esia')
};

/* eslint-disable react/jsx-no-bind */

export default class SocialProfile extends React.Component {
    state = {
        showAplId: false
    };
    onShowAplIdClick = () => {
        this.setState({showAplId: true});
    };
    getName = (username, phonish) => {
        switch (this.props.providerCode) {
            case 'ya':
                return (phonish.display_name || {}).name;
            case 'apl':
                return i18n('Profile2.social.apl.placeholder');
            default:
                return username;
        }
    };
    render() {
        const {profiles, isTouch, providerCode, onClick, sendMetrics} = this.props;
        const {showAplId} = this.state;
        const isPhonish = providerCode === 'ya';

        return (
            <div data-t='pssp:social-profile'>
                <div className='s-block__sub'>{socialNames[providerCode]}</div>
                {profiles.map((
                    {username, profileId, profile_id: ID, phonish = {}} // eslint-disable-line no-extra-parens
                ) => (
                    <div className='s-block__sub s-block__sub_hl soc-profile' key={profileId || ID}>
                        <div className={`soc-profile__icon p-icon__${providerCode}`} />
                        <div className='soc-profile__name'>
                            <span onClick={sendMetrics}>
                                <Link href={link} onClick={onClick}>
                                    {this.getName(username, phonish)}
                                </Link>
                            </span>
                        </div>
                        {!isPhonish && !isTouch && (
                            <span onClick={sendMetrics}>
                                <div
                                    className='soc-profile__settings p-icon__gear'
                                    onClick={extracted.showAllSettingsHandler.bind(this, profileId)}
                                />
                            </span>
                        )}
                        {providerCode === 'apl' && (
                            <div className='soc-profile__apl-code' onClick={this.onShowAplIdClick}>
                                {showAplId ? username : i18n('Profile2.social.apl.show')}
                            </div>
                        )}
                    </div>
                ))}
            </div>
        );
    }
}

SocialProfile.propTypes = {
    sendMetrics: PropTypes.func.isRequired,
    providerCode: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    profiles: PropTypes.array.isRequired,
    isTouch: PropTypes.bool.isRequired,
    onClick: PropTypes.func.isRequired
};
