import api from '@blocks/api';
import {setSubscriptionsErrors, setSubscriptionsInfo, setSubscriptionsInfoProgressState} from './actions';

export const getSubscriptionCards = () => {
    return (dispatch, getState) => {
        const state = getState() || {};
        const {common = {}} = state;
        const {csrf} = common;

        dispatch(setSubscriptionsInfoProgressState(true));

        api.request('subscriptions.cards', {csrf})
            .fail((response) => {
                dispatch(setSubscriptionsInfoProgressState(false));
                dispatch(setSubscriptionsErrors(response.errors || ['internal']));
            })
            .done((response) => {
                const {status, errors} = response;

                if (status !== 'error') {
                    dispatch(setSubscriptionsInfo(response));
                } else {
                    dispatch(
                        setSubscriptionsErrors(Array.isArray(errors) && errors.length > 0 ? errors : ['internal'])
                    );
                }
            });
    };
};
