import {SET_SUBSCRIPTIONS_ERRORS, SET_SUBSCRIPTIONS_INFO, SET_SUBSCRIPTIONS_INFO_PROGRESS_STATE} from './actions';

const defaultState = {
    subscriptions: [],
    plusProgress: true,
    plusErrors: []
};

export default function subscriptionsReducer(state = defaultState, action = {}) {
    switch (action.type) {
        case SET_SUBSCRIPTIONS_INFO:
            return Object.assign({}, state, {
                subscriptions: action.subscriptions,
                plusErrors: [],
                plusProgress: false
            });
        case SET_SUBSCRIPTIONS_INFO_PROGRESS_STATE:
            return Object.assign({}, state, {
                plusProgress: action.progress
            });
        case SET_SUBSCRIPTIONS_ERRORS:
            return Object.assign({}, state, {
                plusErrors: action.errors
            });
        default:
            return state;
    }
}
