import React from 'react';
import {useSelector} from 'react-redux';

import {Widget, Config, Block, presets} from '@yandex-int/messenger.widget';

import {cn} from '@bem-react/classname';
import './SupportWidget.styl';
import {getSupportChatByAlias} from '../utils/supportChats';

const b = cn('SupportWidget');
const WORKSPACE_ID = 'support';
const SERVICE_ID = 42;
const pageClassName = 'YaSupportWidgetPage';
const flags = {
    hideClose: '1',
    recommendedContacts: '0',
    disableChatListHeader: '1',
    disableOpenInNewTabButton: '1',
    notificationSuggest: '0'
};
const themeVariables = {
    'common-bg': '#FFFFFF',
    'common-bg-secondary': '#F1F2F5',
    'common-text-primary': '#262633',
    'common-text-secondary': '#9397AD',
    'common-icons-primary': '#262633',
    'common-icons-secondary': '#9397AD',
    'common-divider': '#E6E9F0',
    'common-settings-item': '#FFFFFF',
    'common-actionbar': '#FFFFFF',
    'common-accent': '#4D8EFF',
    'common-accent-text': '#4D8EFF',
    'common-online': '#3BC46D',
    'common-destructive': '#FF4D4D',
    'common-counter': '#4D8EFF',
    'incoming-bg': '#F1F2F5',
    'incoming-primary': '#262633',
    'incoming-secondary': '#9397AD',
    'incoming-link': '#4D8EFF',
    'incoming-button': '#FFFFFF',
    'outgoing-bg': '#EBF2FF',
    'outgoing-primary': '#262633',
    'outgoing-secondary': '#4D8EFF',
    'outgoing-link': '#4D8EFF',
    'outgoing-button': '#FFFFFF'
};

function getPresets(env) {
    switch (env) {
        case 'production':
            return [presets.origin.external.prod, presets.backend.prod, presets.type.external.multiChats];
        case 'rc':
            return [presets.origin.external.prod, presets.backend.prod, presets.type.external.multiChats];
        case 'development':
            return [presets.origin.external.dev, presets.backend.test, presets.type.external.multiChats];
        case 'testing':
            return [presets.origin.external.dev, presets.backend.test, presets.type.external.multiChats];
        default:
            return [presets.origin.external.dev, presets.backend.test, presets.type.external.multiChats];
    }
}

export const SupportWidget = (props) => {
    const widgetContainerRef = React.useRef(null);
    const widgetRef = React.useRef(null);
    const settings = useSelector((state) => state.settings);
    const {
        env: {type: env},
        tld,
        language
    } = settings;
    const {match = {}} = props || {};
    const {params = {}} = match;
    const {guid} = params;

    React.useEffect(() => {
        document.body.classList.add(pageClassName);

        return () => {
            document.body.classList.remove(pageClassName);
        };
    });

    React.useEffect(() => {
        if (!widgetContainerRef.current) {
            return;
        }

        let widget = widgetRef.current;

        if (!widget) {
            const config = new Config(...getPresets(env), {
                flags,
                themeVariables,
                allow: ['microphone', 'camera']
            }).create({
                workspaceId: WORKSPACE_ID,
                serviceId: SERVICE_ID,
                lang: language,
                tld
            });

            widget = new Widget(config);

            widgetRef.current = widget;

            widget.setUI(new Block(widgetContainerRef.current));
            widget.init();
        }

        if (guid) {
            widget.show({
                guid: getSupportChatByAlias(guid, env) || guid
            });
        } else {
            widget.show({
                chatList: true
            });
        }

        return () => {
            widget.destroy();
        };
    }, [env, language, tld, guid]);

    return <div className={b()} ref={widgetContainerRef} />;
};
