const supportChatAliases = {
    testing: {
        music: 'b39e4b08-1d1b-9419-6c13-5cfbf315de98'
    },
    production: {
        plus: '80027008-e39a-986b-5f64-822d65ab117c',
        uslugi: '3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        kinopoisk: '9394b605-89aa-957e-5cd1-5fc7d79a9034',
        music: 'ee219503-b69b-9484-405b-6877a510e13c',
        station: 'bde37cf3-eb59-4f93-8e5b-1809858a9ac1',
        tv: '2dfbe86d-09dc-4441-a68b-6e591a7abda6',
        afisha: '23fe7556-efee-420c-8b76-55dfb2733225',
        direct: '840c4ce4-ed25-4c66-a7c7-ba8c001e02d9',
        q: 'efcf11b5-ffc2-4ff6-ae6d-79190d7c5419',
        surveys: '41c58a75-35e3-4f16-82ea-3420759a8af0',
        invest: '1e560e75-4d04-4fd1-ae38-670a778fda79',
        zapravki: '3d8f0007-f610-914e-45f7-3eddaf3cc441',
        messenger: '5d8e56bb-08ab-4fe8-ac54-7d9e7d4f6b5c'
    }
};

export function getSupportChatByAlias(alias, env) {
    switch (env) {
        case 'production':
            return supportChatAliases.production[alias];
        case 'rc':
            return supportChatAliases.production[alias];
        case 'development':
            return supportChatAliases.testing[alias];
        case 'testing':
            return supportChatAliases.testing[alias];
        default:
            return supportChatAliases.testing[alias];
    }
}
