import React, {forwardRef} from 'react';
import {useSelector, shallowEqual} from 'react-redux';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './tile.styl';

const b = cn('ProfileTile');

export const Tile = forwardRef(({isMain, children, className}, ref) => {
    const {v2, isLite, isNewLayout} = useSelector(
        ({common = {}, settings = {}}) => ({
            v2: common.v2 || false,
            isLite: settings.isLite,
            isNewLayout: settings.isNewLayout
        }),
        shallowEqual
    );

    return (
        <div ref={ref} className={b({main: isMain, v2, v1: !v2, nl: !isLite && isNewLayout}, [className])}>
            <div className={b('border')} />
            {children}
        </div>
    );
});

Tile.propTypes = {
    isMain: PropTypes.bool,
    className: PropTypes.string,
    children: PropTypes.node.isRequired
};
