/* eslint-disable no-invalid-this */

export function setHeightAsync() {
    clearTimeout(this.timer);
    this.timer = setTimeout(() => {
        this.setState({
            height: getHeight.call(this)
        });
    }, 100);
}

export function shouldComponentUpdate(nextProps, nextState) {
    return nextState !== this.state || nextProps.items !== this.props.items;
}

export function getHeight() {
    if (!this.elements.length) {
        return 0;
    }

    const {items, alwaysShown, margin} = this.props;
    const count = Math.min(items.length, alwaysShown);

    let blockHeight = 0;

    if (this.listOpened) {
        this.elements.forEach((block) => {
            blockHeight += block.getBoundingClientRect().height + margin;
        });
    } else {
        for (let i = 0; i < count; ++i) {
            blockHeight += this.elements[i].getBoundingClientRect().height + margin;
        }
    }

    return blockHeight;
}

export function toggleList() {
    this.listOpened = !this.listOpened;

    this.setState({
        height: getHeight.call(this)
    });
}
