import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Link} from '@components/Link';

import listen from '../../../common/event_listeners';

import * as extracted from './toggle.js';

export default class Toggle extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            height: 0
        };
        this.listOpened = false;
        this.elements = [];
        this.toggleList = extracted.toggleList.bind(this);
    }

    componentDidMount() {
        const setHeightAsync = extracted.setHeightAsync.bind(this);

        setHeightAsync();
        this.destroyListener = listen('resize', setHeightAsync);
    }

    componentDidUpdate(prevProps) {
        if (prevProps.items.length !== this.props.items.length) {
            extracted.setHeightAsync.call(this);
        }
    }

    shouldComponentUpdate(nextProps, nextState) {
        return extracted.shouldComponentUpdate.call(this, nextProps, nextState);
    }

    componentWillUnmount() {
        this.destroyListener();
        clearTimeout(this.timer);
    }

    render() {
        const {
            items,
            title,
            alwaysShown,
            toggleText,
            itemClassName,
            itemOnClick,
            itemKey,
            toggleMax,
            openList,
            cls,
            dt
        } = this.props;
        const isLimited = toggleMax && items.length - alwaysShown > toggleMax && openList;
        const isOpened = this.listOpened && !isLimited;

        this.elements = [];

        return (
            <div className={cls} data-t={dt}>
                <div className={`s-block__sub ${cls}__title`} data-t={`${dt}-title`}>
                    {title}
                </div>
                <div
                    className={`p-toggle__list ${cls}__list`}
                    style={{
                        height: this.state.height
                    }}
                    data-t={`${dt}-list`}
                >
                    {(isLimited ? items.slice(0, alwaysShown) : items).map((item, ndx) => (
                        <div
                            className={classnames(itemClassName, `${cls}__item`, 'p-toggle__item', {
                                'p-toggle__unconfirmed': item.hasOwnProperty('confirmed') && !item.confirmed
                            })}
                            key={ndx}
                            ref={(element) => {
                                if (element) {
                                    this.elements.push(element);
                                }
                            }}
                            data-t={`${dt}-item`}
                            onClick={itemOnClick}
                        >
                            {itemKey ? item[itemKey] : item}
                        </div>
                    ))}
                </div>
                {items.length > alwaysShown && toggleText.length > 0 && (
                    <div
                        className={`s-block__sub  ${cls}__${isOpened ? 'hide' : 'more'}`}
                        data-t={`${cls}-${isOpened ? 'hide' : 'more'}`}
                    >
                        <Link pseudo={true} onClick={isLimited ? openList : this.toggleList}>
                            {isOpened ? i18n('Profile.devices.hide') : toggleText}
                        </Link>
                    </div>
                )}
            </div>
        );
    }
}

Toggle.defaultProps = {
    alwaysShown: 2,
    margin: 0
};

Toggle.propTypes = {
    dt: PropTypes.string.isRequired,
    cls: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    items: PropTypes.array.isRequired,
    alwaysShown: PropTypes.number.isRequired,
    toggleText: PropTypes.string.isRequired,
    itemClassName: PropTypes.string,
    itemOnClick: PropTypes.func,
    itemKey: PropTypes.string,
    margin: PropTypes.number,
    toggleMax: PropTypes.number,
    openList: PropTypes.func
};
