import {connect} from 'react-redux';

import {Passwords} from './Passwords';

const mapStateToProps = function(state = {}) {
    const {settings = {}, person: {avatarId, language} = {}} = state;

    return {
        usrImg:
            settings.avatar &&
            settings.avatar.avatar_300 &&
            settings.avatar.avatar_300.replace('%avatar_id%', avatarId),
        osFamily: settings.ua && settings.ua.OSFamily,
        lang: language,
        isYandexApp: Boolean(settings.ua && settings.ua.BrowserName === 'YandexSearch')
    };
};

const ConnectedPasswords = connect(mapStateToProps)(Passwords);

export {ConnectedPasswords as Passwords};
