import {setDisplayNameEmpty, changePersonalInfo, setPersonalInfoProgressState, setPersonalInfoErrors} from './actions';
import {setDisplayName} from '@blocks/morda/components/header/actions';
import api from '@blocks/api';

const propsMap = {
    display_name: 'displayName'
};

export const GLOBAL_FORM_ERRORS = 'etc';

const fields = ['birthday', 'country', 'city', 'display_name', 'firstname', 'lastname', 'timezone'];

function transformProps(props = {}, isRequest) {
    const _props = $.extend({}, props);

    Object.keys(props).forEach((key) => {
        if ($.isPlainObject(props[key])) {
            _props[isRequest ? key : propsMap[key] || key] = isRequest ? props[key].value : props[key].entry;
        } else {
            _props[propsMap[key] || key] = props[key];
        }
    });

    return _props;
}

function transformErrors(errors = []) {
    const _errors = {};

    errors.forEach((error) => {
        const _error = error.split('.');

        if (fields.indexOf(_error[0]) !== -1) {
            _errors[_error[0]] = _error[1];
        } else {
            _errors[GLOBAL_FORM_ERRORS] = error;
        }
    });

    return _errors;
}

export function fetchPersonalInfo(props, isDisplayNameForm = false) {
    return function(dispatch) {
        dispatch(setPersonalInfoProgressState(true));

        api.request('update.profile', transformProps(props, true))
            .fail((response) => dispatch(setPersonalInfoErrors(transformErrors(response.errors))))
            .done(() => {
                api.request('get.profile', {})
                    .fail(() => dispatch(changePersonalInfo(transformProps(props))))
                    .done((response) => {
                        const transformed = transformProps(response.person);

                        dispatch(changePersonalInfo(transformed));
                        dispatch(setDisplayName(String(transformed.uid), transformed.displayName));

                        if (isDisplayNameForm) {
                            dispatch(setDisplayNameEmpty(false));
                        }
                    });
            });
    };
}
