import React from 'react';
import ReturnToService from '@blocks/morda/components/return_button/return_button.jsx';
import {setPersonalInfoUpdateStatus, clearPersonalInfoFieldsErrors} from './actions';
import {fetchPersonalInfo, GLOBAL_FORM_ERRORS} from './';
import {Name, Gender, Birthday, Timezone, Country, City} from '@blocks/morda/components';
import {ControlWithErrors} from '@blocks/morda/components/control/control.jsx';
import {push} from 'connected-react-router';
import {Button} from '@components/Button';
import {Spin} from '@components/Spin';
import util from '@blocks/utils';
import metrics from '@blocks/metrics';

export class PersonalInfoEditForm extends ControlWithErrors {
    constructor(props) {
        super(props);
        this.displayName = 'personalInfoEditForm';

        this.savePersonalInfo = this.savePersonalInfo.bind(this);
    }

    componentWillMount() {
        const props = this.props;

        this.isTouch = props.settings.ua && (props.settings.ua.isMobile || props.settings.ua.isTouch);
    }

    componentWillUnmount() {
        if (typeof window !== 'undefined') {
            $('.popup_theme_islands').remove(); // ugly shit
        }
    }

    componentDidMount() {
        this.props.dispatch(clearPersonalInfoFieldsErrors());
    }

    componentWillReceiveProps(nextProps) {
        const retpath = this.props.common.retpath;

        if (nextProps.person.updated) {
            this.props.dispatch(setPersonalInfoUpdateStatus(false));

            if (typeof this.props.close === 'function') {
                this.props.close();
                return;
            }

            if (typeof window !== 'undefined') {
                if (retpath && window.location.href !== retpath) {
                    if (util.isThirdPartyUrl(retpath)) {
                        window.location = retpath;
                        return;
                    }

                    this.props.dispatch(push(retpath));
                    return;
                }

                this.props.dispatch(push('/profile'));
                return;
            }
        }

        if (nextProps.edit !== this.props.edit && nextProps.edit !== 'personal-info') {
            this.setValuesFromProps();
            this.refs.city.setState({city: ''});
        }
    }

    setValuesFromProps() {
        Object.keys(this.refs).forEach((ref) => {
            if (typeof this.refs[ref].setValueFromProps === 'function') {
                this.refs[ref].setValueFromProps();
            }
        });
    }

    savePersonalInfo(event) {
        if (event && typeof event.preventDefault === 'function') {
            event.preventDefault();
        }

        let props = {};

        Object.keys(this.refs).forEach((ref) => {
            const component = this.refs[ref];
            const newProps = (typeof component.getRequestParams === 'function' && component.getRequestParams()) || {};

            props = $.extend({}, props, newProps);
        });

        this.props.dispatch(fetchPersonalInfo(props));
        metrics.send(['Изменить персональные данные', 'Сохранить']);
    }

    getEntryView() {
        const props = this.props;
        const {ua, isLite} = props.settings;
        const person = props.person;
        const {isMobile, isTouch, isTablet} = ua;
        const isPhone = (isMobile || isTouch) && !isTablet;
        const retpath = props.common.retpath;

        return (
            <div className={`p-control-form personal-info-form ${props.modal ? 'p-control-modal' : ''}`}>
                <form method='post' onSubmit={this.savePersonalInfo} data-t='personal-info'>
                    <div className='section-head'>
                        <h2 className='section-title'>{i18n('Profile.personal.data')}</h2>
                    </div>

                    <Name
                        {...{
                            isVerifiedAccount: person.isVerifiedAccount,
                            firstname: person.firstname,
                            lastname: person.lastname,
                            dispatch: props.dispatch,
                            errors: {
                                firstname: person.errors.firstname,
                                lastname: person.errors.lastname
                            },
                            ref: 'name'
                        }}
                    />

                    <div className='p-control-double'>
                        <Birthday
                            {...{
                                birthday: person.birthday,
                                isTouch: this.isTouch,
                                dispatch: props.dispatch,
                                errors: {
                                    birthday: person.errors.birthday
                                },
                                ref: 'birthday'
                            }}
                        />
                    </div>

                    <div className='p-control-double'>
                        <Gender
                            {...{
                                gender: person.gender,
                                ref: 'gender'
                            }}
                        />
                    </div>

                    <div />

                    <div className='p-control-double'>
                        <Country
                            {...{
                                country: person.country,
                                countries: props.common.countries,
                                dispatch: props.dispatch,
                                settings: props.settings,
                                isTouch: this.isTouch,
                                ref: 'country'
                            }}
                        />
                    </div>

                    <div className='p-control-double'>
                        <City
                            {...{
                                city: person.city,
                                settings: props.settings,
                                dispatch: props.dispatch,
                                errors: {
                                    city: person.errors.city
                                },
                                ref: 'city'
                            }}
                        />
                    </div>

                    <Timezone
                        {...{
                            timezone: person.timezone,
                            timezones: props.common.timezones,
                            dispatch: props.dispatch,
                            settings: props.settings,
                            isTouch: this.isTouch,
                            errors: {
                                timezone: person.errors.timezone
                            },
                            ref: 'timezone'
                        }}
                    />

                    <div className='p-control-saveblock'>
                        <div className='p-control-saveblock-cell-left'>
                            <ReturnToService retpath={retpath} isModal={props.modal} isMobile={isPhone} />
                        </div>
                        {Boolean(props.modal) && (
                            <div className='p-control-saveblock-cell-left'>
                                <span className='p-control-saveblock-button' data-t='personal-info-bt-cancel'>
                                    <Button size='l' view='pseudo' type='link' onClick={props.close}>
                                        {i18n('_AUTH_.cancel.operation')}
                                    </Button>
                                </span>
                            </div>
                        )}
                        <div className='p-control-saveblock-cell-right personal-saveblock'>
                            <span className='p-control-saveblock-button' data-t='personal-info-bt-save'>
                                <Button size='l' view='action' type='submit' width={isMobile ? 'max' : 'auto'}>
                                    {i18n('Frontend.save')}
                                </Button>
                            </span>
                            <span className='personal-spinner'>
                                <Spin size='s' progress={person.progress} />
                            </span>
                        </div>
                    </div>

                    {super.getErrorView.call(this, {
                        directions: ['left-center']
                    })}

                    {!isLite && (
                        <div
                            className='personal-info-eula'
                            dangerouslySetInnerHTML={{
                                __html: i18n(
                                    'EULA.confidential.link.external.supplemented',
                                    'control link link_theme_normal'
                                )
                            }}
                        />
                    )}
                </form>
            </div>
        );
    }
}

PersonalInfoEditForm.defaultProps = {
    field: GLOBAL_FORM_ERRORS
};
