import {
    CHANGE_PERSONAL_INFO,
    SET_PERSONAL_INFO_PROGRESS_STATE,
    SET_PERSONAL_INFO_ERRORS,
    SET_ENTER_WITHOUT_PASSWORD,
    SET_PERSONAL_INFO_UPDATE_STATUS,
    CLEAR_PERSONAL_INFO_FIELD_ERRORS,
    CLEAR_PERSONAL_INFO_FIELDS_ERRORS,
    PERSON_SET_DISPLAY_NAME_EMPTY,
    UPDATE_MAIN_AVATAR
} from './actions';

import {GLOBAL_FORM_ERRORS} from './';

export default function person(state = {}, action = {}) {
    switch (action.type) {
        case PERSON_SET_DISPLAY_NAME_EMPTY:
            return Object.assign({}, state, {
                isDisplayNameEmpty: action.isEmpty
            });
        case CHANGE_PERSONAL_INFO:
            return $.extend({}, state, action.props, {
                progress: false,
                updated: true,
                errors: {}
            });
        case SET_ENTER_WITHOUT_PASSWORD:
            return Object.assign({}, state, {
                loginOptions: action.payload
            });
        case SET_PERSONAL_INFO_PROGRESS_STATE:
            return $.extend({}, state, {
                progress: action.progress,
                updated: false,
                errors: {}
            });
        case SET_PERSONAL_INFO_ERRORS:
            return $.extend({}, state, {
                progress: false,
                updated: false,
                errors: action.errors
            });
        case SET_PERSONAL_INFO_UPDATE_STATUS:
            return $.extend({}, state, {
                updated: action.updated
            });
        case CLEAR_PERSONAL_INFO_FIELD_ERRORS: {
            const _state = $.extend({}, state);

            delete _state.errors[action.field];
            delete _state.errors[GLOBAL_FORM_ERRORS];
            return _state;
        }

        case CLEAR_PERSONAL_INFO_FIELDS_ERRORS:
            return $.extend({}, state, {
                errors: {}
            });
        case UPDATE_MAIN_AVATAR:
            return $.extend({}, state, {
                avatarId: action.avatarId
            });
        default:
            return state;
    }
}
