import api from '@blocks/api';
import metrics from '@blocks/metrics';
import reloadCaptcha from '@components/Captcha/actions/reloadCaptcha';
export const RESTORE_LOGIN_GOAL_PREFIX = 'restore_login';

export const RESTORE_LOGIN_CHANGE_STEP = 'RESTORE_LOGIN_CHANGE_STEP';
export const RESTORE_LOGIN_TOGGLE_LOGIN = 'RESTORE_LOGIN_TOGGLE_LOGIN';
export const RESTORE_LOGIN_GO_BACK = 'RESTORE_LOGIN_GO_BACK';
export const RESTORE_LOGIN_DESCREASE_COUNTER = 'RESTORE_LOGIN_DESCREASE_COUNTER';
export const RESTORE_LOGIN_CLEAR_ERRORS = 'RESTORE_LOGIN_CLEAR_ERRORS';
export const RESTORE_LOGIN_SUBMIT_PHONE = 'RESTORE_LOGIN_SUBMIT_PHONE';
export const RESTORE_LOGIN_SUBMIT_PHONE_SUCCESS = 'RESTORE_LOGIN_SUBMIT_PHONE_SUCCESS';
export const RESTORE_LOGIN_SUBMIT_PHONE_FAIL = 'RESTORE_LOGIN_SUBMIT_PHONE_FAIL';
export const RESTORE_LOGIN_SUBMIT_CODE = 'RESTORE_LOGIN_SUBMIT_CODE';
export const RESTORE_LOGIN_SUBMIT_CODE_SUCCESS = 'RESTORE_LOGIN_SUBMIT_CODE_SUCCESS';
export const RESTORE_LOGIN_SUBMIT_CODE_FAIL = 'RESTORE_LOGIN_SUBMIT_CODE_FAIL';
export const RESTORE_LOGIN_SUBMIT_NAME = 'RESTORE_LOGIN_SUBMIT_NAME';
export const RESTORE_LOGIN_SUBMIT_NAME_SUCCESS = 'RESTORE_LOGIN_SUBMIT_NAME_SUCCESS';
export const RESTORE_LOGIN_SUBMIT_NAME_FAIL = 'RESTORE_LOGIN_SUBMIT_NAME_FAIL';

export function toggleLoginSelection(login) {
    return {
        type: RESTORE_LOGIN_TOGGLE_LOGIN,
        login
    };
}

export function changeLoginRecoveryStep(step) {
    return {
        type: RESTORE_LOGIN_CHANGE_STEP,
        step
    };
}

export function goBack() {
    return {
        type: RESTORE_LOGIN_GO_BACK
    };
}

export function clearErrors() {
    return {
        type: RESTORE_LOGIN_CLEAR_ERRORS
    };
}

function validatePhone(data) {
    const errors = [];

    if (!data.phone_number.trim()) {
        errors.push('phone.empty');
    }
    if ('captcha' in data && !data.captcha.trim()) {
        errors.push('captcha.empty');
    }

    return errors.length ? errors : null;
}

export function submitPhone({phone, captcha, resend}) {
    return function(dispatch, getState) {
        const {settings, common} = getState();
        const data = {
            track_id: common.track_id,
            phone_number: phone,
            display_language: settings.language,
            csrf_token: common.csrf
        };

        if (!resend) {
            data.captcha = captcha;
        }

        const errors = validatePhone(data);

        if (errors) {
            dispatch({
                type: RESTORE_LOGIN_SUBMIT_PHONE_FAIL,
                errors
            });
            return;
        }

        dispatch({
            type: RESTORE_LOGIN_SUBMIT_PHONE,
            phone
        });
        api.request('restore/login/submit.phone', data)
            .done(() => {
                dispatch({
                    type: RESTORE_LOGIN_SUBMIT_PHONE_SUCCESS,
                    phone,
                    resend
                });
                let countdown = 30;

                const intervalId = setInterval(function() {
                    dispatch({
                        type: RESTORE_LOGIN_DESCREASE_COUNTER
                    });
                    countdown -= 1;

                    if (countdown === 0) {
                        clearInterval(intervalId);
                    }
                }, 1000);
            })
            .fail((res) => {
                dispatch({
                    type: RESTORE_LOGIN_SUBMIT_PHONE_FAIL,
                    errors: res.errors
                });
            })
            .always(() => {
                dispatch(reloadCaptcha());
            });
    };
}

function validateCode(data) {
    const errors = [];

    if (!data.code.trim()) {
        errors.push('code.empty');
    }

    return errors.length ? errors : null;
}

export function submitCode({code}) {
    return function(dispatch, getState) {
        const {common} = getState();
        const data = {
            track_id: common.track_id,
            csrf_token: common.csrf,
            code
        };
        const errors = validateCode(data);

        if (errors) {
            dispatch({
                type: RESTORE_LOGIN_SUBMIT_CODE_FAIL,
                errors
            });
            return;
        }

        dispatch({
            type: RESTORE_LOGIN_SUBMIT_CODE,
            data
        });

        api.request('restore/login/submit.code', data)
            .done(() => {
                metrics.send(`${RESTORE_LOGIN_GOAL_PREFIX}_phone_confirmed`);
                metrics.goal(`${RESTORE_LOGIN_GOAL_PREFIX}_phone_confirmed`);
                dispatch({
                    type: RESTORE_LOGIN_SUBMIT_CODE_SUCCESS
                });
            })
            .fail((res) => {
                dispatch({
                    type: RESTORE_LOGIN_SUBMIT_CODE_FAIL,
                    errors: res.errors
                });
            });
    };
}

function validateName(data) {
    const errors = [];

    if (!data.firstname.trim()) {
        errors.push('firstname.empty');
    }
    if (!data.lastname.trim()) {
        errors.push('lastname.empty');
    }

    return errors.length ? errors : null;
}

export function submitName({firstName, lastName}) {
    return function(dispatch, getState) {
        const {common} = getState();
        const data = {
            track_id: common.track_id,
            csrf_token: common.csrf,
            firstname: firstName,
            lastname: lastName
        };
        const errors = validateName(data);

        if (errors) {
            dispatch({
                type: RESTORE_LOGIN_SUBMIT_NAME_FAIL,
                errors
            });
            return;
        }

        dispatch({
            type: RESTORE_LOGIN_SUBMIT_NAME,
            firstName,
            lastName
        });
        metrics.send(`${RESTORE_LOGIN_GOAL_PREFIX}_submit_name`);
        metrics.goal(`${RESTORE_LOGIN_GOAL_PREFIX}_submit_name`);

        api.request('restore/login/submit.name', data)
            .done((response) => {
                dispatch({
                    type: RESTORE_LOGIN_SUBMIT_NAME_SUCCESS,
                    suggestedLogins: response.accounts
                });
            })
            .fail((res) => {
                dispatch({
                    type: RESTORE_LOGIN_SUBMIT_NAME_FAIL,
                    errors: res.errors
                });
            });
    };
}
