import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Input} from '@components/Input';

class AutofocusInput extends Component {
    constructor(props) {
        super(props);

        this.onChange = this.onChange.bind(this);

        this.state = {
            fieldValue: ''
        };
    }

    onChange(event) {
        const {target = {}} = event;
        const {value} = target;

        this.setState({fieldValue: value});
    }

    value() {
        return this.state.fieldValue;
    }

    render() {
        const {name} = this.props;

        return <Input value={this.state.fieldValue} onChange={this.onChange} focused={true} name={name} size='l' />;
    }
}

AutofocusInput.propTypes = {
    name: PropTypes.string.isRequired
};

export default AutofocusInput;
