import {
    RESTORE_LOGIN_GO_BACK,
    RESTORE_LOGIN_TOGGLE_LOGIN,
    RESTORE_LOGIN_CHANGE_STEP,
    RESTORE_LOGIN_DESCREASE_COUNTER,
    RESTORE_LOGIN_CLEAR_ERRORS,
    RESTORE_LOGIN_SUBMIT_PHONE,
    RESTORE_LOGIN_SUBMIT_PHONE_SUCCESS,
    RESTORE_LOGIN_SUBMIT_PHONE_FAIL,
    RESTORE_LOGIN_SUBMIT_CODE,
    RESTORE_LOGIN_SUBMIT_CODE_SUCCESS,
    RESTORE_LOGIN_SUBMIT_CODE_FAIL,
    RESTORE_LOGIN_SUBMIT_NAME,
    RESTORE_LOGIN_SUBMIT_NAME_SUCCESS,
    RESTORE_LOGIN_SUBMIT_NAME_FAIL
} from './actions';

export default function restoreLogin(state = {}, action) {
    switch (action.type) {
        case RESTORE_LOGIN_CHANGE_STEP: {
            return Object.assign({}, state, {
                errors: {},
                step: state.step.concat(action.step)
            });
        }
        case RESTORE_LOGIN_TOGGLE_LOGIN: {
            const prevLogin = state.selectedLogin;

            return Object.assign({}, state, {
                selectedLogin: prevLogin === action.login ? null : action.login
            });
        }
        case RESTORE_LOGIN_GO_BACK: {
            const lastIndex = state.step.length - 1;

            return Object.assign({}, state, {
                errors: {},
                step: state.step.slice(0, lastIndex)
            });
        }
        case RESTORE_LOGIN_DESCREASE_COUNTER: {
            return Object.assign({}, state, {
                countdown: state.countdown - 1
            });
        }
        case RESTORE_LOGIN_CLEAR_ERRORS: {
            return Object.assign({}, state, {
                errors: {}
            });
        }
        case RESTORE_LOGIN_SUBMIT_PHONE: {
            return Object.assign({}, state, {
                loading: true,
                phone: action.phone
            });
        }
        case RESTORE_LOGIN_SUBMIT_CODE: {
            return Object.assign({}, state, {
                loading: true
            });
        }
        case RESTORE_LOGIN_SUBMIT_NAME: {
            return Object.assign({}, state, {
                loading: true,
                firstName: action.firstName,
                lastName: action.lastName
            });
        }
        case RESTORE_LOGIN_SUBMIT_PHONE_SUCCESS: {
            return Object.assign({}, state, {
                loading: false,
                phone: action.phone,
                countdown: 30,
                errors: {},
                step: action.resend ? state.step : state.step.concat('verify_code')
            });
        }
        case RESTORE_LOGIN_SUBMIT_PHONE_FAIL: {
            const stepLength = state.step.length;
            const lastStep = state.step[stepLength - 1];

            let step = state.step;
            const captchaNotMatched = action.errors.find((err) => err === 'captcha.not_matched');
            const phoneInvalid = action.errors.find(
                (err) => err === 'phone_number.invalid' || err === 'number.invalid'
            );
            const phoneEmpty = action.errors.find((err) => err === 'phone.empty');
            const captchaEmpty = action.errors.find((err) => err === 'captcha.empty');
            const notFound = action.errors.find((err) => err === 'phone_secure.not_found');
            const smsLimitExceeded = action.errors.find((err) => err === 'sms_limit.exceeded');
            const rateLimitExceeded = action.errors.find((err) => err === 'rate.limit_exceeded');
            const errors = {};

            if (captchaNotMatched) {
                errors.captcha = 'notMatched';
            }
            if (phoneInvalid) {
                errors.phone = 'invalid';
            }
            if (phoneEmpty) {
                errors.phone = 'empty';
            }
            if (captchaEmpty) {
                errors.captcha = 'empty';
            }
            if (notFound) {
                errors.phone = 'notFound';
                errors.code = 'notFound';
                step = lastStep === 'verify_code' ? state.step.slice(0, stepLength - 1) : state.step;
            }
            if (smsLimitExceeded) {
                errors.phone = 'smsLimitExceeded';
                errors.code = 'smsLimitExceeded';
            }
            if (rateLimitExceeded) {
                errors.phone = 'rateLimitExceeded';
            }

            return Object.assign({}, state, {
                loading: false,
                step,
                errors
            });
        }
        case RESTORE_LOGIN_SUBMIT_CODE_SUCCESS: {
            return Object.assign({}, state, {
                loading: false,
                phone: action.phone,
                errors: {},
                step: state.step.concat('ask_name')
            });
        }
        case RESTORE_LOGIN_SUBMIT_CODE_FAIL: {
            let step = state.step;
            const errors = {};
            const codeEmpty = action.errors.find((err) => err === 'code.empty');
            const codeInvalid = action.errors.find((err) => err === 'code.invalid');
            const notFound = action.errors.find((err) => err === 'phone_secure.not_found');
            const rateLimitExceeded = action.errors.find(
                (err) => err === 'rate.limit_exceeded' || err === 'confirmations_limit.exceeded'
            );

            if (codeEmpty) {
                errors.code = 'empty';
            }
            if (codeInvalid) {
                errors.code = 'notMatched';
            }
            if (rateLimitExceeded) {
                errors.code = 'rateLimitExceeded';
            }
            if (notFound) {
                errors.phone = 'notFound';
                step = state.step.slice(0, state.step.length - 1);
            }

            return Object.assign({}, state, {
                loading: false,
                step,
                errors
            });
        }
        case RESTORE_LOGIN_SUBMIT_NAME_FAIL: {
            const errors = {};
            const firstNameEmpty = action.errors.find((err) => err === 'firstname.empty');
            const lastNameEmpty = action.errors.find((err) => err === 'lastname.empty');
            const notMatched = action.errors.find((err) => err === 'compare.not_matched');
            const rateLimitExceeded = action.errors.find((err) => err === 'rate.limit_exceeded');

            if (firstNameEmpty) {
                errors.firstName = 'empty';
            }

            if (lastNameEmpty) {
                errors.lastName = 'empty';
            }
            if (notMatched) {
                errors.firstName = 'notMatched';
            }
            if (rateLimitExceeded) {
                errors.firstName = 'rateLimitExceeded';
                errors.lastName = 'rateLimitExceeded';
            }

            return Object.assign({}, state, {
                loading: false,
                errors
            });
        }
        case RESTORE_LOGIN_SUBMIT_NAME_SUCCESS: {
            return Object.assign({}, state, {
                loading: false,
                errors: {},
                suggestedLogins: action.suggestedLogins,
                step: state.step.concat('name_suggested_logins')
            });
        }
    }

    return state;
}
