import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import utils from '../../../utils';
import metrics from '../../../metrics';

export class LastAuth extends Component {
    constructor(props) {
        super(props);

        this.authTypes = {
            imap: i18n('ProfileJournal.profile.journal.enter-imap'),
            smtp: i18n('ProfileJournal.profile.journal.enter-imap'),
            xmpp: i18n('ProfileJournal.profile.journal.enter-xmpp'),
            webdav: i18n('ProfileJournal.profile.journal.enter-webdav'),
            caldav: i18n('ProfileJournal.profile.journal.enter-calendar'),
            'password-oauth': i18n('ProfileJournal.profile.journal.enter-mobile')
        };
    }

    getDate() {
        if (!this.props.timestamp) {
            return '';
        }

        return utils
            .dateToText(new Date(this.props.timestamp * 1000), {
                time: true
            })
            .toLowerCase();
    }

    getEntry() {
        const authType =
            this.props.authtype === 'web'
                ? (this.props.browser && this.props.browser.name) || ''
                : this.authTypes[this.props.authtype] || '';

        if (this.props.region) {
            return `${authType}, ${this.props.region}`;
        }

        return `${authType}`;
    }

    sendMetrics() {
        metrics.send(['История входов']);
    }

    render() {
        const entry = this.getEntry();
        const date = this.getDate();

        return (
            <div className='last-auth'>
                {Boolean(date) && (
                    <div>
                        <div>{i18n('Profile.lastauth.entry', date)}</div>
                        {Boolean(entry) && <div>{entry}</div>}
                    </div>
                )}

                {Boolean(!date && entry) && <div>{i18n('Profile.lastauth.entry', entry)}</div>}

                <span onMouseDown={this.sendMetrics}>
                    <Link href='/profile/journal?origin=passport_profile'>{i18n('Profile.lastauth.label')}</Link>
                </span>
            </div>
        );
    }
}

LastAuth.propTypes = {
    timestamp: PropTypes.string,
    authtype: PropTypes.string,
    region: PropTypes.string,
    browser: PropTypes.shape({
        name: PropTypes.string
    })
};
