import api from '../../../api';
import {saveActionForRepeat} from '../../../common/actions';

export const SAVE_KVKO = 'SAVE_KVKO';
export const SAVE_KVKO_SUCCESS = 'SAVE_KVKO_SUCCESS';
export const SET_KVKO_UPDATE_STATUS = 'SET_KVKO_UPDATE_STATUS';
export const SAVE_KVKO_FAIL = 'SAVE_KVKO_FAIL';
export const CHANGE_CONTROL_QUESTION = 'CHANGE_CONTROL_QUESTION';
export const SHOW_KVKO_MODAL = 'SHOW_KVKO_MODAL';
export const VALIDATE_KVKO_FORM = 'VALIDATE_KVKO_FORM';
export const SET_QUESTIONS = 'SET_QUESTIONS';
export const DELETE_FIELD_ERROR = 'DELETE_FIELD_ERROR';

export function deleteFieldError(field) {
    return {
        type: DELETE_FIELD_ERROR,
        field
    };
}

export function showKvKo(visible) {
    return {
        type: SHOW_KVKO_MODAL,
        visible
    };
}

export function setKvKoUpdateStatus(updated) {
    return {
        type: SET_KVKO_UPDATE_STATUS,
        updated
    };
}

export function validateForm(data) {
    return {
        type: VALIDATE_KVKO_FORM,
        data
    };
}

export function setQuestions(questions) {
    return {
        type: SET_QUESTIONS,
        questions
    };
}

export function saveKvKo(data) {
    return function(dispatch, getState) {
        const state = getState();
        const {uid, track_id} = state.common;
        const {available, errors} = state.security.controlQuestion;
        const {language} = state.settings;
        const payload = $.extend({}, data, {
            uid,
            track_id,
            language
        });

        if (Object.keys(errors).length !== 0) {
            return;
        }
        dispatch({
            type: SAVE_KVKO
        });
        dispatch(saveActionForRepeat(saveKvKo, data));
        api.request('saveQuestion', payload)
            .done(() => {
                const payload = {
                    type: SAVE_KVKO_SUCCESS,
                    currentQuestion: {
                        id: data.newQuestionId
                    }
                };

                if (data.ownQuestion) {
                    payload.currentQuestion.text = data.ownQuestion;
                } else {
                    payload.currentQuestion.text = available.find((q) => q.val === data.newQuestionId).text;
                }
                dispatch(payload);
            })
            .fail((res) => {
                dispatch({
                    type: SAVE_KVKO_FAIL,
                    res
                });
            });
    };
}

export function changeQuestion(id) {
    return {
        type: CHANGE_CONTROL_QUESTION,
        id
    };
}
