import {setQuestions} from './actions';
import api from '../../../api';

function transformQuestions(questions) {
    return questions.map(function(question) {
        return {
            val: question.id,
            text: question.value
        };
    });
}

export default function getQuestions() {
    return (dispatch) => {
        api.request('getQuestions', {}).then((response) => {
            if (response && response.questions && response.questions.length) {
                dispatch(setQuestions(transformQuestions(response.questions)));
            }
        });
    };
}
