import {
    CHANGE_CONTROL_QUESTION,
    VALIDATE_KVKO_FORM,
    SHOW_KVKO_MODAL,
    SAVE_KVKO,
    SAVE_KVKO_SUCCESS,
    SAVE_KVKO_FAIL,
    SET_KVKO_UPDATE_STATUS,
    DELETE_FIELD_ERROR,
    SET_QUESTIONS
} from './actions';

export default function(state = {}, action) {
    switch (action.type) {
        case DELETE_FIELD_ERROR: {
            const errors = Object.assign({}, state.errors);

            delete errors[action.field];

            return Object.assign({}, state, {errors});
        }
        case CHANGE_CONTROL_QUESTION:
            return Object.assign({}, state, {
                selected: action.id
            });
        case SHOW_KVKO_MODAL: {
            const data = {
                visible: action.visible
            };

            if (!data.visible) {
                data.errors = {};
            }
            return Object.assign({}, state, data);
        }
        case SAVE_KVKO:
            return Object.assign({}, state, {
                loading: true
            });
        case SAVE_KVKO_SUCCESS:
            return Object.assign({}, state, {
                selected: '0',
                visible: false,
                loading: false,
                current: action.currentQuestion,
                updated: true
            });
        case SAVE_KVKO_FAIL: {
            const responseErrors = action.res.errors;
            const errors = {};

            responseErrors.forEach((error) => {
                switch (error) {
                    case 'compare.not_matched': {
                        errors.oldAnswer = 'notMatched';
                        break;
                    }
                    case 'rate.limit_exceeded': {
                        errors.rateLimitExceeded = true;
                        break;
                    }
                    case 'question.long': {
                        errors.ownQuestion = 'long';
                        break;
                    }
                    case 'new_answer.long': {
                        errors.newAnswer = 'long';
                        break;
                    }
                    case 'old_answer.long': {
                        errors.oldAnswer = 'long';
                    }
                }
            });

            return Object.assign({}, state, {
                loading: false,
                errors
            });
        }
        case SET_KVKO_UPDATE_STATUS:
            return Object.assign({}, state, {
                updated: action.updated
            });
        case VALIDATE_KVKO_FORM: {
            const errors = {};
            const formData = action.data;

            for (const key in formData) {
                if (formData[key] === '') {
                    errors[key] = 'empty';
                }
            }
            if (formData.newQuestionId === '0') {
                errors.newQuestionId = 'empty';
            }
            return Object.assign({}, state, {
                errors
            });
        }
        case SET_QUESTIONS: {
            return Object.assign({}, state, {
                available: action.questions
            });
        }
        default:
            return state;
    }
}
