import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {push} from 'react-router-redux';
import {Modal} from '@components/Modal';
import {showKvKo, setKvKoUpdateStatus} from './actions';
import {showRegPopup} from '@blocks/common/actions';
import KvKoModal from './modal.jsx';
import Link from '@blocks/morda/components/link/link.jsx';
import metrics from '@blocks/metrics';

const changeHintUrl = '/profile/change-hint';

export class UserQuestion extends Component {
    constructor(props) {
        super(props);
        this.showKvKoModal = this.showKvKoModal.bind(this);
    }

    showKvKoModal(event) {
        const {settings, access, dispatch} = this.props;
        const isPhone = (settings.ua.isMobile || settings.ua.isTouch) && !settings.ua.isTablet;

        this.sendMetrics();
        if (access.passwordInfo.strength === -1 && !access.is2faEnabled) {
            dispatch(showRegPopup(true));
        } else if (isPhone) {
            dispatch(push(changeHintUrl));
        } else {
            dispatch(showKvKo(true));
            dispatch(setKvKoUpdateStatus(false));
        }

        event.preventDefault();
    }

    sendMetrics() {
        metrics.send(['Изменить контрольный вопрос/ответ', 'Открыть форму']);
    }

    render() {
        const {
            controlQuestion: {current, visible}
        } = this.props.security;

        return (
            <div>
                <Link url={changeHintUrl} onClick={this.showKvKoModal}>
                    {current ? i18n('Profile.personal.hint.change') : i18n('Profile.personal.hint.add')}
                </Link>
                <Modal visible={visible} className='question__fix-select' dataT='user-question'>
                    {visible && <KvKoModal {...this.props} modal={true} />}
                </Modal>
            </div>
        );
    }
}

UserQuestion.propTypes = {
    dispatch: PropTypes.func.isRequired,
    settings: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    common: PropTypes.object.isRequired,
    security: PropTypes.object.isRequired
};
