import {push} from 'connected-react-router';
import api from '../../api';
import {saveActionForRepeat, showRegPopup} from '../../common/actions';

export const CHANGE_PROFILE_AUTH_PERMIT = 'CHANGE_PROFILE_AUTH_PERMIT';

export const GET_SOCIAL_PROFILES = 'GET_SOCIAL_PROFILES';
export const GET_SOCIAL_PROFILES_SUCCESS = 'GET_SOCIAL_PROFILES_SUCCESS';
export const GET_SOCIAL_PROFILES_ERROR = 'GET_SOCIAL_PROFILES_ERROR';

export const DELETE_SOCIAL_PROFILE = 'DELETE_SOCIAL_PROFILE';
export const DELETE_SOCIAL_PROFILE_SUCCESS = 'DELETE_SOCIAL_PROFILE_SUCCESS';
export const DELETE_SOCIAL_PROFILE_ERROR = 'DELETE_SOCIAL_PROFILE_ERROR';

export const SHOW_SOCIAL_PROFILE_ALL_SETTINGS = 'SHOW_SOCIAL_PROFILE_ALL_SETTINGS';
export const SHOW_DELETE_POPUP = 'SHOW_DELETE_POPUP';

export const CHANGE_PROFILE_SUBSCRIPTION = 'CHANGE_PROFILE_SUBSCRIPTION';

export const SINGLE_AUTH_METHOD_ERROR = 'SINGLE_AUTH_METHOD_ERROR';

export function changeProfileAuthPermit(profileId, allowAuth) {
    return {
        type: CHANGE_PROFILE_AUTH_PERMIT,
        profileId,
        allowAuth
    };
}

export function getSocialProfiles() {
    return function(dispatch) {
        dispatch({
            type: GET_SOCIAL_PROFILES
        });
        return api
            .request('get.profile', {})
            .done((store) => {
                dispatch({
                    type: GET_SOCIAL_PROFILES_SUCCESS,
                    store
                });
            })
            .fail((error) => {
                dispatch({
                    type: GET_SOCIAL_PROFILES_ERROR,
                    error
                });
            });
    };
}

export function deleteSocialProfile(profileId) {
    return function(dispatch, getState) {
        const state = getState();
        const {csrf, uid, track_id} = state.common;
        const ua = state.settings.ua;
        const isPhone = ua.isMobile || (ua.isTouch && !ua.isTablet);

        dispatch({
            type: DELETE_SOCIAL_PROFILE,
            profileId
        });
        dispatch(saveActionForRepeat(deleteSocialProfile, profileId));
        return api
            .request('delSocialProfile', {
                track_id,
                csrf_token: csrf,
                profile_id: profileId,
                uid,
                passErrors: true
            })
            .done(() => {
                if (isPhone) {
                    dispatch(push('/profile/social'));
                }
                dispatch({
                    type: DELETE_SOCIAL_PROFILE_SUCCESS,
                    profileId
                });
            })
            .fail((response) => {
                if (response.errors && response.errors.find((err) => err === 'social_profile.single_auth_method')) {
                    dispatch(showRegPopup(true));
                }
                dispatch({
                    type: DELETE_SOCIAL_PROFILE_ERROR,
                    error: response
                });
            });
    };
}

export function showAllSettings(profileId) {
    return {
        type: SHOW_SOCIAL_PROFILE_ALL_SETTINGS,
        profileId
    };
}

export function showDeletePopup(shown) {
    return {
        type: SHOW_DELETE_POPUP,
        shown
    };
}

export function changeSubscription(profileId, sid, isEnabled) {
    return {
        type: CHANGE_PROFILE_SUBSCRIPTION,
        profileId,
        sid,
        isEnabled
    };
}

export function allowAuthMethodError(profileId = 0, error = '') {
    return {
        type: SINGLE_AUTH_METHOD_ERROR,
        profileId,
        error
    };
}
