import {saveActionForRepeat, showRegPopup} from '../../../common/actions';
import {changeProfileAuthPermit} from '../actions';
import api from '../../../api';

export function saveProfileAuthPermit(profileId, allowAuth) {
    return function(dispatch, getState) {
        const {csrf, uid, track_id} = getState().common;

        dispatch(changeProfileAuthPermit(profileId, allowAuth));
        dispatch(saveActionForRepeat(saveProfileAuthPermit, profileId, allowAuth));
        return api
            .request(
                `allowSocialAuth?profile_id=${profileId}`,
                {
                    track_id,
                    csrf_token: csrf,
                    profile_id: profileId,
                    set_auth: Number(allowAuth),
                    uid,
                    passErrors: true
                },
                {
                    cache: false,
                    abortPrevious: true
                }
            )
            .then((e) => {
                if (e.state === 'complete_social_with_login') {
                    dispatch(changeProfileAuthPermit(profileId, false));
                    dispatch(showRegPopup(true));
                }
            })
            .fail(() => {
                dispatch(changeProfileAuthPermit(profileId, !allowAuth));
            });
    };
}
