import {changeSubscription} from '../actions';
import api from '../../../api';

export function saveProfileSubscription(profileId, sid, isEnabled) {
    return function(dispatch, getState) {
        const {csrf, uid, track_id} = getState().common;
        const url = isEnabled ? 'enableSocialSubscribe' : 'disableSocialSubscribe';

        dispatch(changeSubscription(profileId, sid, isEnabled));
        return api
            .request(
                url,
                {
                    csrf_token: csrf,
                    track_id,
                    profile_id: profileId,
                    uid,
                    sid
                },
                {
                    cache: false,
                    abortPrevious: true
                }
            )
            .fail(() => {
                dispatch(changeSubscription(profileId, sid, !isEnabled));
            });
    };
}
