import React from 'react';
import PropTypes from 'prop-types';

import * as extracted from './add_profiles.js';

export default function AddProfiles({social}) {
    return (
        <div>
            <div className='s-add-profiles'>
                <div className='s-add-profiles__label'>{i18n('Profile.social.add-profile')}</div>
                <ul className='s-add-profiles__available-profiles'>
                    {social.providers.map((provider) => (
                        <li
                            key={provider.data.code}
                            onClick={() => extracted.addSocialProfile(provider.data.code)}
                            className={extracted.getClassName(provider.data.code)}
                        />
                    ))}
                </ul>
            </div>
        </div>
    );
}

AddProfiles.propTypes = {
    social: PropTypes.object.isRequired
};
