import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ProfileItems from '../profile_items/profile_items.jsx';
import Profile from '../profile/profile.jsx';
import ReturnToService from '@blocks/morda/components/return_button/return_button.jsx';

export default class SocialModal extends Component {
    render() {
        const {social, dispatch, modal = false, settings, retpath, common, person = {}, match} = this.props;
        const {isSocialchik} = person;

        const ua = settings.ua;
        const isPhone = ua.isMobile || (ua.isTouch && !ua.isTablet);

        let profileId;

        if (this.props.modal) {
            profileId = social.showAllSettings;
        } else {
            profileId = Number(match.params && match.params.profileId);
        }

        const currentProfile = social.profiles.find((profile) => profile.profileId === profileId);

        return (
            <div className='p-control-form' data-t='social-info'>
                {currentProfile ? (
                    <Profile
                        profile={currentProfile}
                        dispatch={dispatch}
                        modal={modal}
                        isDeletePopupShown={social.isDeletePopupShown}
                        isSocialchik={isSocialchik}
                    />
                ) : (
                    <ProfileItems {...this.props} />
                )}

                <ReturnToService
                    className='social-modal__return-button'
                    retpath={common.backpath || retpath || common.retpath}
                    isModal={modal}
                    isMobile={isPhone}
                />
            </div>
        );
    }
}

SocialModal.propTypes = {
    dispatch: PropTypes.func,
    settings: PropTypes.object,
    social: PropTypes.object,
    person: PropTypes.object,
    common: PropTypes.object,
    params: PropTypes.object,
    modal: PropTypes.bool,
    is2faEnabled: PropTypes.bool,
    passwordStrength: PropTypes.number,
    retpath: PropTypes.string,
    match: PropTypes.shape({
        params: PropTypes.object
    })
};
