import {showAllSettings, deleteSocialProfile, showDeletePopup} from '../actions';

/* eslint-disable no-invalid-this */

export function scrollToTop() {
    if (!this.props.modal) {
        window.scrollTo(0, 0);
    }
}

export function hideAllSettings() {
    const {dispatch} = this.props;

    dispatch(showAllSettings(null));
    dispatch(showDeletePopup(false));
}

export function deleteProfile() {
    const {
        profile: {profileId},
        dispatch
    } = this.props;

    dispatch(showDeletePopup(false));
    dispatch(deleteSocialProfile(profileId));
}

export function showDeletePopupHandler() {
    this.props.dispatch(showDeletePopup(true));
}

export function hideDeletePopup() {
    this.props.dispatch(showDeletePopup(false));
}
