import {push} from 'connected-react-router';
import {showAllSettings} from '../actions';
import {saveProfileAuthPermit} from '../actions/saveProfileAuthPermit';

/* eslint-disable no-invalid-this */

const profilesUrl = '/profile/social/';

export function showAllSettingsHandler() {
    const {
        dispatch,
        profile: {profileId},
        modal
    } = this.props;

    if (modal) {
        dispatch(showAllSettings(profileId));
    } else {
        dispatch(push(profilesUrl + profileId));
    }
}

export function saveProfileAuthPermitHandler() {
    const {
        profile: {profileId, allowAuth},
        dispatch
    } = this.props;

    dispatch(saveProfileAuthPermit(profileId, !allowAuth));
}
