import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Tumbler} from '@components/Tumbler';

import * as extracted from './profile_item.js';

export default class ProfileItem extends Component {
    constructor(props) {
        super(props);

        this.showAllSettings = extracted.showAllSettingsHandler.bind(this);
        this.saveProfileAuthPermit = extracted.saveProfileAuthPermitHandler.bind(this);
    }

    render() {
        const props = this.props;
        const {modal, profile, access, person = {}} = props;
        const {passwordInfo, isSms2faEnabled} = access;
        const {isNeoPhonish, isSocialchik} = person;
        const link = `<a class="b-link"
                href="/passport?mode=postregistration&origin=passport_profile">${i18n('Profile.create_login')}</a>`;
        const code = (profile.provider || {}).code || profile.provider_code;
        const isNoAction = profile.hasOwnProperty('phonish') || code === 'kp';
        const canAuthorize = profile.allowAuth !== 'no_auth' && !passwordInfo.strong_policy_on && !isNoAction;

        // TODO add <a> tag for NOJS browsers
        return (
            <li className={classnames('s-profile-item clearfix', {'s-profile-item_modal': modal})}>
                <div
                    className={classnames(`social-icon social-icon_${code} s-profile-item__icon`, {
                        'social-icon__no-action': isNoAction
                    })}
                    onClick={isNoAction ? undefined : this.showAllSettings}
                />
                <div className='s-profile-item__user'>
                    <div className='s-profile-item__user-wrap'>
                        <span
                            data-t='profile-item:username'
                            className={classnames({
                                's-profile-item__user-name': !isNoAction
                            })}
                            onClick={isNoAction ? undefined : this.showAllSettings}
                        >
                            {isNoAction && code !== 'kp'
                                ? `${i18n('Frontend.phonish.phone')}: ${profile.phonish.display_name.name}`
                                : profile.username}
                        </span>
                        <div className='s-profile-item__gear p-icon__gear' onClick={this.showAllSettings} />
                    </div>
                    {canAuthorize && !profile.allowAuth && isSocialchik && (
                        <div
                            className='s-profile-item__user-action'
                            dangerouslySetInnerHTML={{
                                __html: i18n('ProfileSocial.profile.social.complete-link').replace('%1', link)
                            }}
                        />
                    )}
                    {isNoAction && profile.registrationDate && (
                        <span className='s-profile-item__user-action'>
                            {`${i18n('Frontend.phonish.registered')} ${profile.registrationDate}`}
                        </span>
                    )}
                    {props.allowAuthMethodError && props.allowAuthMethodError.profileId === profile.profileId && (
                        <div className='s-profile__allow-auth-error'>
                            <span className='p-control-error-block'>{props.allowAuthMethodError.error}</span>
                        </div>
                    )}
                </div>
                {canAuthorize && !isSocialchik && !isNeoPhonish && !isSms2faEnabled && (
                    <div className='s-profile-item__user-action'>
                        <Tumbler size='m' checked={profile.allowAuth} onChange={this.saveProfileAuthPermit} />
                    </div>
                )}
            </li>
        );
    }
}

ProfileItem.propTypes = {
    access: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    modal: PropTypes.bool.isRequired,
    profile: PropTypes.shape({
        profileId: PropTypes.number.isRequired,
        provider: PropTypes.object,
        provider_code: PropTypes.string,
        allowAuth: PropTypes.bool,
        phonish: PropTypes.shape({
            display_name: PropTypes.shape({
                name: PropTypes.string
            }).isRequired
        }),
        registrationDate: PropTypes.string,
        username: PropTypes.string
    }).isRequired,

    person: PropTypes.shape({
        displayLogin: PropTypes.string,
        isSocialchik: PropTypes.bool.isRequired,
        isNeoPhonish: PropTypes.bool.isRequired
    }).isRequired,
    allowAuthMethodError: PropTypes.shape({
        profileId: PropTypes.number,
        error: PropTypes.string
    }).isRequired
};
