import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ProfileItem from '../profile_item/profile_item.jsx';
import AddProfiles from '../add_profiles/add_profiles.jsx';

import * as extracted from './profile_items.js';

export default class ProfileItems extends Component {
    componentWillUnmount() {
        extracted.allowAuthMethodErrorHandler.call(this);
    }
    render() {
        const {social, dispatch, modal = false, common, settings, person, access} = this.props;
        const allProfiles = social.profiles.concat(social.phonishes);

        return (
            <div>
                <h2 className='section-title'>{i18n('Profile.social.title')}</h2>

                {!settings.isLite && (
                    <div
                        className='section-info'
                        dangerouslySetInnerHTML={{
                            __html: i18n('ProfileSocial.profile.social.page-description')
                        }}
                    />
                )}

                {!!allProfiles.length && (
                    <div className='social-modal__profiles-list-header'>
                        <span>{i18n('ProfileSocial.profile.social.profiles-header.socials')}</span>
                        {!access.isSms2faEnabled && (
                            <span>{i18n('ProfileSocial.profile.social.profiles-header.tumblers')}</span>
                        )}
                    </div>
                )}

                <div className='social-modal__border' />

                {!!allProfiles.length && (
                    <ul className='social-modal__profiles-list'>
                        {allProfiles.map((profile) => (
                            <ProfileItem
                                access={access}
                                key={profile.profileId}
                                profile={profile}
                                modal={modal}
                                settings={settings}
                                common={common}
                                dispatch={dispatch}
                                person={person}
                                allowAuthMethodError={social.allowAuthMethodError}
                            />
                        ))}
                    </ul>
                )}

                <AddProfiles social={social} />
            </div>
        );
    }
}

ProfileItems.propTypes = {
    access: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    social: PropTypes.object.isRequired,
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    modal: PropTypes.bool,
    person: PropTypes.object
};
