import {
    GET_SOCIAL_PROFILES_SUCCESS,
    DELETE_SOCIAL_PROFILE_SUCCESS,
    CHANGE_PROFILE_AUTH_PERMIT,
    CHANGE_PROFILE_SUBSCRIPTION,
    SHOW_SOCIAL_PROFILE_ALL_SETTINGS,
    SHOW_DELETE_POPUP,
    SINGLE_AUTH_METHOD_ERROR
} from './actions';

export default function social(state = {}, action) {
    switch (action.type) {
        case GET_SOCIAL_PROFILES_SUCCESS:
            return $.extend({}, state, {
                profiles: action.store.social.profiles,
                showAddProfiles: false
            });
        case DELETE_SOCIAL_PROFILE_SUCCESS: {
            const profileIndex = state.profiles.findIndex((profile) => profile.profileId === action.profileId);

            if (profileIndex === -1) {
                return $.extend({}, state);
            }
            return $.extend({}, state, {
                profiles: state.profiles.slice(0, profileIndex).concat(state.profiles.slice(profileIndex + 1)),
                showAllSettings: false
            });
        }
        case CHANGE_PROFILE_AUTH_PERMIT: {
            const profileIndex = state.profiles.findIndex((profile) => profile.profileId === action.profileId);

            if (profileIndex === -1) {
                return $.extend({}, state);
            }
            const newProfile = $.extend({}, state.profiles[profileIndex], {
                allowAuth: action.allowAuth
            });

            return $.extend({}, state, {
                profiles: state.profiles
                    .slice(0, profileIndex)
                    .concat(newProfile, state.profiles.slice(profileIndex + 1))
            });
        }
        case CHANGE_PROFILE_SUBSCRIPTION: {
            const profileIndex = state.profiles.findIndex((profile) => profile.profileId === action.profileId);

            if (profileIndex === -1) {
                return $.extend({}, state);
            }
            const newProfile = $.extend(true, {}, state.profiles[profileIndex]);
            const subscription = newProfile.subscriptions.find((sub) => sub.sid === action.sid);

            subscription.checked = action.isEnabled;
            return $.extend({}, state, {
                profiles: state.profiles
                    .slice(0, profileIndex)
                    .concat(newProfile, state.profiles.slice(profileIndex + 1))
            });
        }
        case SHOW_SOCIAL_PROFILE_ALL_SETTINGS:
            return $.extend({}, state, {
                showAllSettings: action.profileId
            });
        case SHOW_DELETE_POPUP:
            return $.extend({}, state, {
                isDeletePopupShown: action.shown
            });
        case SINGLE_AUTH_METHOD_ERROR:
            return $.extend({}, state, {
                allowAuthMethodError: {
                    profileId: action.profileId,
                    error: action.error
                }
            });
        default: {
            return state;
        }
    }
}
