import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Checkbox} from '@components/Checkbox';

import * as extracted from './subscription';

export default class Subscription extends Component {
    constructor(props) {
        super(props);

        this.changeSubscription = extracted.changeSubscription.bind(this);
    }

    render() {
        const subscription = this.props.subscription;

        return (
            <div className='s-profile__section' data-t={`social:privacy-${subscription.service}`}>
                <div className='s-profile__label'>
                    <div className={`service-icon service-icon_${subscription.service}`} />
                    <span>{subscription.serviceName}</span>
                </div>

                <span className='s-profile__checkbox'>
                    <Checkbox
                        size='m'
                        value={subscription.sid}
                        checked={subscription.checked}
                        onChange={this.changeSubscription}
                    />
                </span>

                {Boolean(subscription.service === 'mail') && (
                    <div className='s-profile__subscription-description'>
                        {i18n('Profile.social.subscription.mail')}
                    </div>
                )}

                {Boolean(subscription.service === 'search') && (
                    <div className='s-profile__subscription-description'>
                        {i18n('Profile.social.subscription.search')}
                    </div>
                )}
            </div>
        );
    }
}

Subscription.propTypes = {
    subscription: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired
};
