const URLS = {
    ru: {
        plus: 'https://plus.yandex.ru',
        'plus.year': 'https://plus.yandex.ru',
        'plus.month': 'https://plus.yandex.ru',
        family_plus: 'https://plus.yandex.ru/family',
        'plus.family': 'https://plus.yandex.ru/family',
        music: 'https://music.yandex.ru/pay',
        kinopoiskhd: 'https://hd.kinopoisk.ru/hd',
        kinopoiskhd_amediateka: 'https://hd.kinopoisk.ru/hd',
        'kp.hd.amediateka': 'https://hd.kinopoisk.ru',
        'kp.hd': 'https://hd.kinopoisk.ru',
        station_lease: 'https://yandex.ru/support/music/station.html',
        station: 'https://music.yandex.ru/station',
        'station-mini': 'https://plus.yandex.ru/station-mini?utm_source=plus&utm_medium=card&utm_campaign=MSCAMP-24',
        beru_plus: 'https://beru.ru',
        beru: 'https://beru.ru',
        disk_plus: 'https://disk.yandex.ru',
        'disk.pro.1000': 'https://disk.yandex.ru',
        'disk.pro.100': 'https://disk.yandex.ru',
        'new-plus': 'https://plus.yandex.ru',
        'new-plus.year': 'https://plus.yandex.ru',
        'new-plus-multi': 'https://plus.yandex.ru/family',
        'new-amediateka-multi': 'https://plus.yandex.ru',
        'kinopoisk-go': 'https://www.kinopoisk.ru/mykp/edit_main/#user-kinopoisk-go-subscription',
        'new-plus-more': 'https://plus.yandex.ru',
        'new-plus-multi-more': 'https://plus.yandex.ru'
    },
    by: {
        plus: 'https://plus.yandex.by',
        'plus.year': 'https://plus.yandex.by',
        'plus.month': 'https://plus.yandex.by',
        family_plus: 'https://plus.yandex.by/family',
        'plus.family': 'https://plus.yandex.by/family',
        station_lease: 'https://yandex.by/support/music/station.html',
        station: 'https://music.yandex.by/station',
        disk_plus: 'https://disk.yandex.by',
        'disk.pro.1000': 'https://disk.yandex.by',
        'disk.pro.100': 'https://disk.yandex.by',
        music: 'https://music.yandex.by/pay',
        'new-plus': 'https://plus.yandex.by',
        'new-plus.year': 'https://plus.yandex.by',
        'new-plus-multi': 'https://plus.yandex.by/family',
        'new-amediateka-multi': 'https://plus.yandex.by',
        'kinopoisk-go': 'https://www.kinopoisk.ru/mykp/edit_main/#user-kinopoisk-go-subscription',
        'new-plus-more': 'https://plus.yandex.by',
        'new-plus-multi-more': 'https://plus.yandex.by'
    },
    uz: {
        plus: 'https://plus.yandex.uz',
        'plus.year': 'https://plus.yandex.uz',
        'plus.month': 'https://plus.yandex.uz',
        family_plus: 'https://plus.yandex.uz/family',
        'plus.family': 'https://plus.yandex.uz/family',
        station_lease: 'https://yandex.uz/support/music/station.html',
        station: 'https://music.yandex.uz/station',
        disk_plus: 'https://disk.yandex.uz',
        'disk.pro.1000': 'https://disk.yandex.uz',
        'disk.pro.100': 'https://disk.yandex.uz',
        music: 'https://music.yandex.uz/pay',
        'new-plus': 'https://plus.yandex.uz',
        'new-plus.year': 'https://plus.yandex.uz',
        'new-plus-multi': 'https://plus.yandex.uz/family',
        'new-amediateka-multi': 'https://plus.yandex.uz',
        'kinopoisk-go': 'https://www.kinopoisk.ru/mykp/edit_main/#user-kinopoisk-go-subscription',
        'new-plus-more': 'https://plus.yandex.uz',
        'new-plus-multi-more': 'https://plus.yandex.uz'
    },
    kz: {
        plus: 'https://plus.yandex.kz',
        'plus.year': 'https://plus.yandex.kz',
        'plus.month': 'https://plus.yandex.kz',
        family_plus: 'https://plus.yandex.kz/family',
        'plus.family': 'https://plus.yandex.kz/family',
        station_lease: 'https://yandex.kz/support/music/station.html',
        station: 'https://music.yandex.kz/station',
        disk_plus: 'https://disk.yandex.kz',
        'disk.pro.1000': 'https://disk.yandex.kz',
        'disk.pro.100': 'https://disk.yandex.kz',
        music: 'https://music.yandex.kz/pay',
        'new-plus': 'https://plus.yandex.kz',
        'new-plus.year': 'https://plus.yandex.kz',
        'new-plus-multi': 'https://plus.yandex.kz/family',
        'new-amediateka-multi': 'https://plus.yandex.kz',
        'kinopoisk-go': 'https://www.kinopoisk.ru/mykp/edit_main/#user-kinopoisk-go-subscription',
        'new-plus-more': 'https://plus.yandex.kz',
        'new-plus-multi-more': 'https://plus.yandex.kz'
    },
    com: {
        station_lease: 'https://music.yandex.com/station',
        station: 'https://music.yandex.com/station',
        disk_plus: 'https://disk.yandex.com',
        'disk.pro.1000': 'https://disk.yandex.com',
        'disk.pro.100': 'https://disk.yandex.com',
        music: 'https://music.yandex.com/pay',
        'new-plus': 'https://plus.yandex.com',
        'new-plus.year': 'https://plus.yandex.com',
        'new-plus-multi': 'https://plus.yandex.com/family',
        'new-amediateka-multi': 'https://plus.yandex.com',
        'new-plus-more': 'https://plus.yandex.com',
        'new-plus-multi-more': 'https://plus.yandex.com'
    },
    'com.tr': {
        disk_plus: 'https://disk.yandex.com.tr',
        'disk.pro.1000': 'https://disk.yandex.com.tr',
        'disk.pro.100': 'https://disk.yandex.com.tr'
    }
};

export const getUrl = (type, tld = 'ru') => {
    const urls = URLS[tld] || URLS.ru;
    const url = urls[type] || URLS.ru[type];

    return url || '';
};

export const buildFormUrl = (form) => {
    return `${form.target}?${Object.keys(form.fields)
        .map((key) => form.fields[key])
        .map(({name, value}) => `${name}=${value}`)
        .join('&')}`;
};

export function getOrigin(url) {
    const [protocol = '', restOfPath = ''] = url.split('//');
    const [domain = ''] = restOfPath.split('/');

    return `${protocol}//${domain}`;
}
