import React from 'react';
import PropTypes from 'prop-types';

import './block.styl';

const Block = ({children}) => {
    const count = React.Children.count(children);

    return (
        <div className='block'>
            {React.Children.map(
                children,
                (child, index) =>
                    child && (
                        <div className={`block__item block__item_col${index === count - 1 ? 4 - count : 1}`}>
                            {child}
                        </div>
                    )
            )}
        </div>
    );
};

Block.propTypes = {
    children: PropTypes.any.isRequired
};

export default Block;
