import React from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import Modal from '../modal/modal.jsx';
import ModalTitle from '../modal/title/modal_title.jsx';
import ModalMessage from '../modal/message/modal_message.jsx';
import ModalActions from '../modal/actions/modal_actions.jsx';

const GLOBAL_LOGOUT_LINK = '/passport?origin=passport_profile&mode=logout&global=1&yu=';

export default class GlobalLogout extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            isModalVisible: false
        };
        this.showAlert = () => this.setState({isModalVisible: true});
        this.closeAlert = () => this.setState({isModalVisible: false});
    }

    shouldComponentUpdate(_, state) {
        return this.state !== state;
    }

    render() {
        const glogoutLink = `${GLOBAL_LOGOUT_LINK}${this.props.yandexuid}`;

        return (
            <React.Fragment>
                <Link pseudo={true} href={glogoutLink} onClick={this.showAlert}>
                    {i18n('Profile.globallogout.link')}
                </Link>
                <Modal isVisible={this.state.isModalVisible} onClose={this.closeAlert}>
                    <React.Fragment>
                        <ModalTitle>{i18n('Profile.globallogout.alert.title')}</ModalTitle>
                        <ModalMessage>
                            <div
                                dangerouslySetInnerHTML={{
                                    __html: i18n('Profile.globallogout.alert.message.yandexteam')
                                }}
                            />
                        </ModalMessage>
                        <ModalActions
                            cancel={{
                                onClick: this.closeAlert
                            }}
                            confirm={{
                                url: glogoutLink
                            }}
                        />
                    </React.Fragment>
                </Modal>
            </React.Fragment>
        );
    }
}

GlobalLogout.propTypes = {
    yandexuid: PropTypes.string.isRequired
};
