import React from 'react';
import PropTypes from 'prop-types';

import {Button} from '@components/Button';

import './modal_actions.styl';

const actionPropTypes = PropTypes.shape({
    onCancel: PropTypes.func,
    onClick: PropTypes.func,
    cls: PropTypes.string,
    url: PropTypes.string,
    title: PropTypes.string,
    disabled: PropTypes.bool
});

const ModalActions = ({cancel, confirm, isLoading}) => (
    <div className='p-modal__actions'>
        {confirm && (
            <div className={`p-modal__actions-item ${confirm.cls}`}>
                <Button
                    size='l'
                    width='max'
                    view='action'
                    url={confirm.url}
                    progress={isLoading}
                    onClick={confirm.onClick}
                    type={confirm.url ? 'link' : undefined}
                    disabled={isLoading || confirm.disabled || (!confirm.onClick && !confirm.url)}
                >
                    {confirm.title || i18n('Frontend.confirm.operation')}
                </Button>
            </div>
        )}
        {cancel && (
            <div className={`p-modal__actions-item ${cancel.cls}`}>
                <Button
                    size='l'
                    width='max'
                    view='pseudo'
                    onClick={cancel.onClick}
                    disabled={isLoading || cancel.disabled || !cancel.onClick}
                >
                    {cancel.title || i18n('_AUTH_.cancel.operation')}
                </Button>
            </div>
        )}
    </div>
);

ModalActions.propTypes = {
    isLoading: PropTypes.bool,
    cancel: actionPropTypes,
    confirm: actionPropTypes
};

export default ModalActions;
