import React from 'react';
import PropTypes from 'prop-types';

import {Modal as LegoModal} from '@components/Modal';

import './modal.styl';

export default class Modal extends React.Component {
    static getDerivedStateFromProps({isVisible, children}, {key}) {
        return isVisible
            ? {
                  children: React.cloneElement(children, {key})
              }
            : {
                  key: Math.random()
              };
    }

    constructor(props) {
        super(props);

        this.state = {
            key: 0,
            children: null
        };
    }

    shouldComponentUpdate({isVisible}) {
        const {isVisible: _isVisible} = this.props;

        return isVisible || isVisible !== _isVisible;
    }

    render() {
        const {onClose, children, isVisible, isLoading} = this.props;

        return (
            <LegoModal visible={isVisible} onClose={isLoading ? undefined : onClose}>
                <div className='p-modal'>
                    {isVisible ? React.cloneElement(children, {key: this.state.key}) : this.state.children}
                </div>
            </LegoModal>
        );
    }
}

Modal.defaultProps = {
    isVisible: false
};

Modal.propTypes = {
    onClose: PropTypes.func,
    isLoading: PropTypes.bool,
    isVisible: PropTypes.bool.isRequired,
    children: PropTypes.any.isRequired
};
