import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import classnames from 'classnames';

import utils from '../../../utils';

import './personal_info.styl';

const PersonalInfo = ({person, language, avatar: {host, pathname}}) => {
    const {
        city,
        login,
        lastname,
        birthday,
        avatarId,
        firstname,
        displayName,
        displayLogin,
        publicDisplayName,
        countryName,
        isDisplayNameEmpty
    } = person;

    const dateParts = utils.dateToText(birthday, {year: true}).split(' ');
    const name = utils.getSplittedDisplayName(isDisplayNameEmpty ? publicDisplayName : displayName);
    const avatarPath = pathname
        .replace('%uid%', avatarId)
        .replace('%login%', login)
        .replace('%size%', '200');

    return (
        <div className='p-info__wrapper'>
            <div
                className='p-info__avatar'
                style={{
                    backgroundImage: `url('//${host}${avatarPath}')`
                }}
            >
                <span className='p-info__avatar-mask' />
            </div>
            <div
                className={classnames('p-info', {
                    'p-info_no-avatar': avatarId === '0/0-0'
                })}
            >
                <div className='p-info__name'>
                    <div className='p-info__first'>{firstname}</div>
                    <div className='p-info__last'>{lastname}</div>
                </div>
                <div className='p-info__login'>{displayLogin}</div>

                <div className='p-info__additional'>
                    {birthday && (
                        <div className='p-info__item p-info__birthday'>
                            <div>
                                <div data-t='profile-info:day_month'>
                                    {dateParts[0]} {(dateParts[1] || '').toLowerCase()}
                                </div>
                                <div data-t='profile-info:year'>
                                    {dateParts[2]} {language === 'ru' && i18n('Profile2.profile.year')}
                                </div>
                            </div>
                        </div>
                    )}
                    {(countryName || city) && (
                        <div className='p-info__item p-info__geo'>
                            {countryName && (
                                <div data-t='profile-info:country' className='p-info__geo-data'>
                                    {countryName}
                                    {city ? ',' : ''}
                                </div>
                            )}
                            {city && (
                                <div data-t='profile-info:city' className='p-info__geo-data'>
                                    {city}
                                </div>
                            )}
                        </div>
                    )}
                    <div className='p-info__item p-info__dname'>
                        <span>{i18n('Profile2.profile.display_name')}: </span>
                        <span className='p-info__displayname'>
                            <span className='p-info_color_red'>{name.head}</span>
                            <span>{name.tail}</span>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    );
};

PersonalInfo.propTypes = {
    person: PropTypes.object.isRequired,
    language: PropTypes.string.isRequired,
    avatar: PropTypes.shape({
        host: PropTypes.string.isRequired,
        pathname: PropTypes.string.isRequired
    }).isRequired
};

export default connect(({person, settings: {avatar, language}}) => ({
    person,
    avatar,
    language
}))(PersonalInfo);
