import React from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';

import {Link} from '@components/Link';

import Modal from '../modal/modal.jsx';
import ModalTitle from '../modal/title/modal_title.jsx';
import ModalError from '../modal/error/modal_error.jsx';
import ModalMessage from '../modal/message/modal_message.jsx';
import ModalActions from '../modal/actions/modal_actions.jsx';

import {setQRError, hideQrCode} from '../../actions';
import {recreateSecret} from '../../thunks';

import './rfc_totp.styl';

export class RfcTotp extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            isModalVisible: false
        };

        this.showModal = () => this.setState({isModalVisible: true});
        this.closeModal = () => {
            this.setState({isModalVisible: false});
            this.props.hideQrCode();
        };
    }

    render() {
        const {
            recreateSecret: recreate,
            rfcTotp: {error, qrSVG, secret, isLoading}
        } = this.props;

        return (
            <React.Fragment>
                <Link pseudo={true} onClick={this.showModal}>
                    {i18n('Profile.totp.create_secret')}
                </Link>

                <Modal isLoading={isLoading} onClose={this.closeModal} isVisible={this.state.isModalVisible}>
                    <React.Fragment>
                        <ModalTitle>{i18n('Profile.totp.alert.title')}</ModalTitle>
                        <ModalError>{error}</ModalError>
                        {qrSVG ? (
                            <div className='rfc_totp-h'>
                                <div className='rfc_totp__qr' dangerouslySetInnerHTML={{__html: qrSVG}} />
                                <div className='rfc_totp__secret'>{secret}</div>
                            </div>
                        ) : (
                            <ModalMessage>
                                <div dangerouslySetInnerHTML={{__html: i18n('Profile.totp.alert.message')}} />
                            </ModalMessage>
                        )}
                        <ModalActions
                            isLoading={isLoading}
                            cancel={{
                                onClick: this.closeModal,
                                title: !qrSVG ? undefined : i18n('Frontend.close')
                            }}
                            confirm={
                                qrSVG
                                    ? undefined
                                    : {
                                          onClick: recreate
                                      }
                            }
                        />
                    </React.Fragment>
                </Modal>
            </React.Fragment>
        );
    }
}

RfcTotp.propTypes = {
    hideQrCode: PropTypes.func.isRequired,
    recreateSecret: PropTypes.func.isRequired,
    rfcTotp: PropTypes.shape({
        qrSVG: PropTypes.string,
        error: PropTypes.string,
        secret: PropTypes.string,
        isLoading: PropTypes.bool
    }).isRequired
};

export default connect(
    ({rfcTotp}) => ({
        rfcTotp
    }),
    (dispatch) => ({
        recreateSecret: () => dispatch(recreateSecret()),
        hideQrCode: () => {
            dispatch(hideQrCode());
            dispatch(setQRError(null));
        }
    })
)(RfcTotp);
