import React from 'react';
import {useSelector, useDispatch, shallowEqual} from 'react-redux';

import {Link} from '@components/Link';

import Block from './components/block/block.jsx';
import Section from './components/section/section.jsx';

import RfcTotp from './components/rfc_totp/rfc_totp.jsx';
import PersonalInfo from './components/personal_info/personal_info.jsx';
import GlobalLogout from './components/global_logout/global_logout.jsx';
import ChangePassword from '../morda/new/auth_block/pass_and_kvko/change_password.jsx';

const MordaIntranet = () => {
    const {yandexuid, login, settings, captcha, passwordStrength, isStrongPolicyOn, retpath} = useSelector(
        ({common, settings, person, access, captcha}) => ({
            captcha,
            settings,
            login: person.login,
            retpath: common.retpath,
            yandexuid: common.yandexuid,
            passwordStrength: access.passwordInfo.strength,
            isStrongPolicyOn: access.passwordInfo.strong_policy_on
        }),
        shallowEqual
    );
    const dispatch = useDispatch();

    return (
        <>
            <PersonalInfo />
            <Section title={i18n('Profile.totp.title')}>
                <Block>
                    <RfcTotp />
                </Block>
            </Section>
            <Section title={i18n('Profile2.titles.passes_auth')}>
                <Block>
                    <ChangePassword
                        login={login}
                        isIntranet={true}
                        captcha={captcha}
                        retpath={retpath}
                        settings={settings}
                        dispatch={dispatch}
                        passwordStrength={passwordStrength}
                        isStrongPolicyOn={isStrongPolicyOn}
                    />
                    <Link pseudo={false} href={`/profile/access `}>
                        {i18n('Profile.devices.title')}
                    </Link>
                </Block>
            </Section>
            <Section>
                <Block>
                    <GlobalLogout yandexuid={yandexuid} />
                    <Link pseudo={false} href={`/passport?origin=passport_profile&mode=logout&yu=${yandexuid}`}>
                        {i18n('Profile.logout.link')}
                    </Link>
                </Block>
            </Section>
        </>
    );
};

export default MordaIntranet;
