import {RFC_SHOW_QR_CODE, RFC_HIDE_QR_CODE, RFC_SET_QR_ERROR, RFC_SET_QR_LOADING} from '../actions';

const reducer = {};

reducer[RFC_SET_QR_ERROR] = ({error}) => ({error});

reducer[RFC_SET_QR_LOADING] = ({isLoading}) => ({isLoading});

reducer[RFC_HIDE_QR_CODE] = () => ({secret: '', qrSVG: null});

reducer[RFC_SHOW_QR_CODE] = ({qrSVG, secret}) => ({qrSVG, secret});

export default (state = {}, action) => {
    if (reducer.hasOwnProperty(action.type)) {
        return Object.assign({}, state, reducer[action.type](action));
    }

    return state;
};
