import api from '../../api';
import {showQrCode, setQRError, setQrLoading} from '../actions';

export const recreateSecret = () => (dispatch) => {
    dispatch(setQRError(null));
    dispatch(setQrLoading(true));
    api.request('rfcTotpRecreateSecret')
        .then((response) => {
            dispatch(showQrCode(response.qrSVG, response.secret));
            dispatch(setQrLoading(false));
        })
        .fail(() => {
            dispatch(setQRError(i18n('Errors.ErrorsTexts.retry')));
            dispatch(setQrLoading(false));
        });
};
