import React, {Component} from 'react';
import PropTypes from 'prop-types';

export class Account extends Component {
    render() {
        const {
            avatar,
            avatarId,
            changeDefaultUrl,
            displayName,
            isAccountListEditing,
            isAuthorized,
            isDefault,
            isTouch,
            login,
            logoutUrl,
            onClick,
            onCrossClick
        } = this.props;

        const isDeleted = !login;

        const spanStyle = {
            backgroundImage: `url(https://${avatar.host}${avatar.pathname
                .replace('%uid%', avatarId)
                .replace('%size%', '200')
                .replace('%login%', login)})`
        };

        function crossClick(e) {
            e.stopPropagation();
            e.preventDefault();
            onCrossClick();
        }

        const showCross = !isTouch || (isTouch && isAccountListEditing);

        if (isDefault) {
            return (
                <li className='passport-AccountList-Item'>
                    <div onClick={onClick} className='passport-AccountList-Link'>
                        {Boolean(showCross) && (
                            <a href={logoutUrl} onClick={crossClick} className='passport-AccountList-Remove'>
                                <span className='passport-Icon passport-Icon_remove' />
                            </a>
                        )}
                        <div style={spanStyle} className='passport-AccountList-Userpic passport-Userpic'>
                            <span className='passport-Icon passport-Icon_ok' />
                        </div>
                        <div className='passport-AccountList-Text'>
                            <strong>{displayName}</strong>
                        </div>
                    </div>
                </li>
            );
        }

        if (isAuthorized) {
            return (
                <li className='passport-AccountList-Item passport-false'>
                    <a onClick={onClick} className='passport-AccountList-Link'>
                        <span
                            href={changeDefaultUrl}
                            style={spanStyle}
                            className='passport-AccountList-Userpic passport-Userpic'
                        >
                            <span className='passport-Icon passport-Icon_ok' />
                        </span>
                        {Boolean(showCross) && (
                            <span onClick={crossClick} className='passport-AccountList-Remove'>
                                <span className='passport-Icon passport-Icon_remove' />
                            </span>
                        )}
                        <span className='passport-AccountList-Text'>{displayName}</span>
                    </a>
                </li>
            );
        }

        return isDeleted ? (
            <li className='passport-AccountList-Item passport-AccountList-Item_needsPassword'>
                <a className='passport-AccountList-Link'>
                    <span style={spanStyle} className='passport-AccountList-Userpic passport-Userpic' />

                    {Boolean(showCross) && (
                        <span onClick={crossClick} className='passport-AccountList-Remove'>
                            <span className='passport-Icon passport-Icon_remove' />
                        </span>
                    )}

                    <span className='passport-AccountList-Text'>Аккаунт удалён</span>
                </a>
            </li>
        ) : (
            <li className='passport-AccountList-Item passport-AccountList-Item_needsPassword'>
                <a onClick={onClick} className='passport-AccountList-Link'>
                    <span style={spanStyle} className='passport-AccountList-Userpic passport-Userpic' />
                    {Boolean(showCross) && (
                        <span onClick={crossClick} className='passport-AccountList-Remove'>
                            <span className='passport-Icon passport-Icon_remove' />
                        </span>
                    )}
                    <span className='passport-AccountList-Text'>{displayName}</span>
                    <span className='passport-AccountList-Note'>{i18n('OneDomik.AccountList.note')}</span>
                </a>
            </li>
        );
    }
}

Account.propTypes = {
    avatarId: PropTypes.string,
    avatar: PropTypes.object,
    displayName: PropTypes.string,
    isAccountListEditing: PropTypes.bool,
    isAuthorized: PropTypes.bool,
    isDefault: PropTypes.bool,
    isTouch: PropTypes.bool,
    login: PropTypes.string,
    onClick: PropTypes.func,
    onCrossClick: PropTypes.func,
    changeDefaultUrl: PropTypes.string,
    logoutUrl: PropTypes.string
};
