import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export class Errors extends Component {
    render() {
        const {code, expandError, isExpanded} = this.props;

        // account.not_found
        // action.not_required
        // captcha.captchalocate
        // captcha.invalid
        // captcha.required
        // login.empty
        // password.empty
        // password.not_matched
        // sessionid.invalid
        // sessionid.no_uid
        // session.no_uid
        // uid.empty
        // yu.empty
        // yu.invalid
        //

        const doNotShow = ['account.auth_passed', 'track.not_found'];

        const messages = {
            'account.disabled': i18n('_AUTH_.Errors.account.disabled'),
            'account.disabled_on_deletion': i18n('_AUTH_.Errors.account.disabled'),
            'account.not_found': i18n('_AUTH_.Errors.account.not_found'),
            'captcha.invalid': i18n('_AUTH_.Errors.captcha.invalid'),
            'captcha.required': i18n('_AUTH_.Errors.captcha.required'),
            'login.empty': i18n('_AUTH_.Errors.login.empty'),
            'password.empty': i18n('_AUTH_.Errors.password.empty'),
            'password.not_matched_2fa': i18n('OneDomik.Errors.password.not_matched_2fa'),
            'password.not_matched': i18n('_AUTH_.Errors.password.not_matched'),
            'rfc_otp.invalid': i18n('_AUTH_.Errors.password.not_matched'),
            'sessionid.overflow': i18n('Errors.ErrorsTexts.sessionidoverflow'),
            'code.invalid': i18n('OneDomik.AuthMailCode.errors.code_invalid'),
            'code.empty': i18n('OneDomik.AuthMailCode.errors.code_empty'),
            'email_confirmations_limit.exceeded': i18n('OneDomik.AuthMailCode.errors.confirmation_limit_exceeded'),
            internal: i18n('_AUTH_.Errors.internal')
        };

        const info = {
            'account.not_found': i18n('OneDomik.Errors.account.not_found.extended'),
            'password.not_matched_2fa': i18n('OneDomik.Errors.password.not_matched_2fa.extended'),
            'password.not_matched': i18n('OneDomik.Errors.password.not_matched.extended'),
            'sessionid.overflow': i18n('Mend.MendTexts.sessionidoverflow')
        };

        const errorFieldClassNames = {
            'passport-Domik-Form-Error': true,
            'passport-Domik-Form-Error_active': Boolean(code)
        };

        if (doNotShow.indexOf(code) !== -1) {
            errorFieldClassNames['passport-Domik-Form-Error_active'] = false;
        }

        return (
            <div className={classnames(errorFieldClassNames)}>
                {messages[code] || (code && messages.internal)}
                {Boolean(!isExpanded && info[code]) && (
                    <a
                        className='passport-Icon passport-Icon_error_help passport-Domik-Form-Error-Icon'
                        onClick={expandError}
                    >
                        <svg className='passport-Icon-SVG'>
                            <use xlinkHref='#Icon_error_help' />
                        </svg>
                    </a>
                )}

                {Boolean(isExpanded && info[code]) && (
                    <div className='passport-Domik-Form-Error__Message'>{info[code]}</div>
                )}
            </div>
        );
    }
}

Errors.propTypes = {
    code: PropTypes.string,
    expandError: PropTypes.func,
    isExpanded: PropTypes.bool
};
