import React, {Component} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import magic from '@blocks/one_domik/magic/magic.js';
import {Captcha} from '@components/Captcha';
import {
    domikIsLoading,
    switchPasswordType,
    switchLoginEmptyState,
    switchPasswordEmptyState,
    switchFormSubmittedState,
    switchCaptchaEmptyState
} from '../actions';
import metrics from '../../metrics';

export class Form extends Component {
    constructor(props) {
        super(props);
        this.handleLoginChange = this.handleLoginChange.bind(this);
        this.handlePasswordChange = this.handlePasswordChange.bind(this);
        this.handleCaptchaChange = this.handleCaptchaChange.bind(this);
        this.passwordFocus = this.passwordFocus.bind(this);
        this.captchaFocus = this.captchaFocus.bind(this);
        this.loginFocus = this.loginFocus.bind(this);
        this.switchPasswordType = this.switchPasswordType.bind(this);
        this.switchLoginEmptyState = this.switchLoginEmptyState.bind(this);
        this.switchPasswordEmptyState = this.switchPasswordEmptyState.bind(this);
        this.switchCaptchaEmptyState = this.switchCaptchaEmptyState.bind(this);
        this.sendMetrics = this.sendMetrics.bind(this);
        this.onSubmit = this.onSubmit.bind(this);
    }

    sendMetrics(params) {
        metrics.send(params);
    }

    onSubmit() {
        metrics.send([this.props.method ? 'Экран саджеста' : 'Экран пустого домика', 'Отправка формы авторизации']);

        if (this.props.passwordType === 'text') {
            this.switchPasswordType();
        }

        this.props.dispatch(domikIsLoading(true));
        this.props.dispatch(switchFormSubmittedState(true));

        return true;
    }

    switchPasswordType() {
        this.props.dispatch(switchPasswordType(this.props.passwordType === 'text' ? 'password' : 'text'));
    }

    switchLoginEmptyState() {
        this.props.dispatch(switchLoginEmptyState(this.loginInput.value === ''));
    }

    switchPasswordEmptyState() {
        this.props.dispatch(switchPasswordEmptyState(this.passwordInput.value === ''));
    }

    switchCaptchaEmptyState() {
        this.props.dispatch(switchCaptchaEmptyState(this.captchaInput.value === ''));
    }

    componentDidMount() {
        if (this.props.method === 'magic') {
            magic.start();
        }

        if (this.loginInput) {
            if (this.props.form.login) {
                this.loginInput.value = this.props.form.login;
            }

            this.switchLoginEmptyState();
        }

        if (this.passwordInput) {
            this.switchPasswordEmptyState();
        }

        if (this.captchaInput) {
            this.switchCaptchaEmptyState();
        }

        if (!this.props.method && this.props.focused) {
            this.loginFocus();
        }

        if (this.props.method && this.props.method !== 'magic' && this.props.focused) {
            this.passwordFocus();
        }
    }

    componentDidUpdate(prevProps) {
        if (this.props.method === 'magic') {
            if (prevProps.track_id !== this.props.track_id) {
                magic.restart();
            }
        }

        if (!this.props.errors && prevProps.focused !== this.props.focused) {
            if (!this.props.method) {
                this.loginFocus();
            } else {
                this.passwordFocus();
            }
        }

        if (['login.empty', 'account.not_found'].indexOf(this.props.errors) > -1) {
            this.loginFocus();
        }

        if (
            [
                'password.not_matched',
                'password.not_matched_2fa',
                'rfc_otp.invalid',
                'code.invalid',
                'code.empty',
                'password.empty'
            ].indexOf(this.props.errors) > -1
        ) {
            if (this.props.submitCounter !== prevProps.submitCounter) {
                this.passwordInput.value = '';
                this.props.dispatch(switchPasswordEmptyState(true));
                this.passwordFocus();
            }
        }

        if (['captcha.required', 'captcha.invalid'].indexOf(this.props.errors) > -1) {
            if (this.props.submitCounter !== prevProps.submitCounter) {
                this.captchaInput.value = '';
                this.props.dispatch(switchCaptchaEmptyState(true));
                this.captchaFocus();
            }
        }
    }

    componentWillUnmount() {
        if (this.props.method === 'magic') {
            magic.stop();
        }
    }

    handleLoginChange() {
        // this.props.updateLoginValue(this.loginInput.value);
        this.props.clearErrors();
    }

    handlePasswordChange() {
        // this.props.updatePasswordValue(this.passwordInput.value);
    }

    handleCaptchaChange() {
        // this.props.updateCaptchaValue(this.captchaInput.value);
    }

    passwordFocus() {
        setTimeout(() => this.passwordInput && this.passwordInput.focus(), 0);
    }

    captchaFocus() {
        setTimeout(() => this.captchaInput && this.captchaInput.focus(), 0);
    }

    loginFocus() {
        setTimeout(() => this.loginInput && this.loginInput.focus(), 0);
    }

    render() {
        const {
            captcha,
            isMobile,
            isMobileCaptcha,
            isIE,
            method,
            realRetpath,
            formIsSubmitted,
            formSettings,
            from,
            fretpath,
            clean,
            captchaRequired,
            inputLogin,
            login,
            switchToMagic,
            allowedAuthMethods,
            track_id, // eslint-disable-line
            errors,
            form,
            passwordType,
            rfc,
            showPolicyTick,
            isPhoneNumberExperiment
        } = this.props;

        const props = this.props;

        const label = isPhoneNumberExperiment
            ? i18n('OneDomik.Form.Label.LoginOrPhoneNumber')
            : i18n('OneDomik.Form.Label.Login');

        const spanStyle = {
            backgroundImage: `url("/auth/magic/code/?track_id=${track_id}")` // eslint-disable-line
        };

        const loginHiddenStyle = {
            display: 'none'
        };

        const passwordEyeClassnames = {
            'password-eye': true,
            'password-eye__hidden': passwordType === 'text'
        };

        const loginInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && this.props.loginIsEmpty
        };

        const passwordInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && this.props.passwordIsEmpty
        };

        const captchaInputClassnames = {
            'passport-Input': true,
            'passport-Input_empty': isIE && this.props.captchaIsEmpty
        };

        const passwordFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field_with_toggle': Boolean(isMobile),
            'passport-Domik-Form-Field-State_error':
                ['password.not_matched', 'password.empty', 'code.empty', 'code.invalid'].indexOf(errors) > -1 &&
                this.passwordInput &&
                this.passwordInput.value === ''
        };

        const loginFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field-State_error':
                ['account.not_found', 'account.dissbled', 'login.empty'].indexOf(errors) > -1
        };

        const captchaFieldClassnames = {
            'passport-Domik-Form-Field': true,
            'passport-Domik-Form-Field-State_error':
                ['captcha.required', 'captcha.invalid'].indexOf(errors) > -1 &&
                this.captchaInput &&
                this.captchaInput.value === ''
        };

        return (
            <form
                method='post'
                target={formSettings.target}
                action={formSettings.handle}
                onSubmit={this.onSubmit}
                className='passport-Domik-Form'
            >
                <input type='hidden' name='real_retpath' value={realRetpath} />
                <input type='hidden' name='from' value={from} />
                <input type='hidden' name='fretpath' value={fretpath} />
                <input type='hidden' name='clean' value={clean} />
                <input type='hidden' name='idkey' value={track_id} />
                <input type='hidden' name='extended' value='1' />
                <input type='hidden' name='csrf_token' value={this.props.csrf} />
                <input type='hidden' name='one' value='1' />

                {Boolean(formSettings.retpath) && <input type='hidden' name='retpath' value={formSettings.retpath} />}

                {Boolean(form.pdd_domain) && <input type='hidden' name='pdd_domain' value={form.pdd_domain} />}

                {Boolean(method) && <input type='hidden' name='source' value={method} />}

                {Boolean(!method) && (
                    <div className={classnames(loginFieldClassnames)}>
                        <label className={classnames(loginInputClassnames)}>
                            <input
                                onChange={this.handleLoginChange}
                                onInput={this.switchLoginEmptyState}
                                name='login'
                                type='text'
                                autoCorrect='off'
                                autoCapitalize='off'
                                autoComplete='username'
                                placeholder=' '
                                ref={(input) => {
                                    this.loginInput = input;
                                }}
                                className='passport-Input-Controller'
                            />
                            <span className='passport-Input-View'>
                                <span className='passport-Input-Label'>{label}</span>
                            </span>
                        </label>
                    </div>
                )}

                {method === 'email_code' && (
                    <div>
                        <div className={classnames(passwordFieldClassnames)}>
                            {Boolean(isMobile) && (
                                <span className={classnames(passwordEyeClassnames)} onClick={this.switchPasswordType} />
                            )}

                            <label className={classnames(passwordInputClassnames)}>
                                <input type='hidden' name='email_code' value='1' readOnly={true} />

                                <input
                                    name='password'
                                    type={passwordType}
                                    autoCorrect='off'
                                    autoCapitalize='off'
                                    autoComplete='off'
                                    placeholder=' '
                                    onInput={this.switchPasswordEmptyState}
                                    className='passport-Input-Controller'
                                    ref={(input) => {
                                        this.passwordInput = input;
                                    }}
                                />

                                <span className='passport-Input-View'>
                                    <span className='passport-Input-Label'>
                                        {i18n('OneDomik.AuthMailCode.field_label')}
                                    </span>
                                </span>
                            </label>
                        </div>
                    </div>
                )}

                {Boolean(method === 'otp' || method === 'magic') && (
                    <div>
                        {Boolean(track_id && method === 'magic') && (
                            <div className='passport-Domik-Form-Field'>
                                <div className='qr-code'>
                                    <div className='qr-code__i' style={spanStyle} />
                                </div>
                            </div>
                        )}

                        <div className={classnames(passwordFieldClassnames)}>
                            {Boolean(isMobile) && (
                                <span className={classnames(passwordEyeClassnames)} onClick={this.switchPasswordType} />
                            )}

                            <label className={classnames(passwordInputClassnames)}>
                                {Boolean(!rfc) && (
                                    <input
                                        type='hidden'
                                        name='login'
                                        autoComplete='username'
                                        value={login}
                                        readOnly={true}
                                    />
                                )}

                                {Boolean(rfc) && <input type='hidden' name='rfc' value='1' readOnly={true} />}

                                <input
                                    name='password'
                                    type={passwordType}
                                    autoCorrect='off'
                                    autoCapitalize='off'
                                    autoComplete={rfc ? 'one-time-code' : 'password'}
                                    placeholder=' '
                                    onInput={this.switchPasswordEmptyState}
                                    className='passport-Input-Controller'
                                    ref={(input) => {
                                        this.passwordInput = input;
                                    }}
                                />

                                <span className='passport-Input-View'>
                                    <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.OTP')}</span>
                                </span>
                            </label>
                        </div>
                    </div>
                )}

                {Boolean(!method || method === 'password') && (
                    <div ref='password' className={classnames(passwordFieldClassnames)}>
                        {Boolean(isMobile) && (
                            <span className={classnames(passwordEyeClassnames)} onClick={this.switchPasswordType} />
                        )}

                        <label className={classnames(passwordInputClassnames)}>
                            {Boolean(method) && (
                                <input
                                    autoComplete='username'
                                    name='login'
                                    readOnly={true}
                                    style={loginHiddenStyle}
                                    type='text'
                                    value={inputLogin || login}
                                />
                            )}

                            <input
                                className='passport-Input-Controller'
                                name='passwd'
                                type={passwordType}
                                autoCorrect='off'
                                autoCapitalize='off'
                                autoComplete={passwordType === 'password' ? 'current-password' : 'off'}
                                placeholder=' '
                                onInput={this.switchPasswordEmptyState}
                                ref={(input) => {
                                    this.passwordInput = input;
                                }}
                            />

                            <span className='passport-Input-View'>
                                <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.Password')}</span>
                            </span>
                        </label>
                    </div>
                )}

                {Boolean(captchaRequired) && (
                    <div>
                        <div className='passport-Domik-Form-Field'>
                            <Captcha
                                isMobile={isMobileCaptcha}
                                lang={props.lang}
                                introSound={captcha.introSound}
                                captchaSound={captcha.captchaSound}
                                imageUrl={captcha.imageUrl}
                                loading={captcha.loading}
                                loadingAudio={captcha.loadingAudio}
                                playing={captcha.playing}
                                type={captcha.type}
                                dispatch={props.dispatch}
                                visible={Boolean(captchaRequired)}
                            />
                        </div>
                        <div className={classnames(captchaFieldClassnames)}>
                            <label className={classnames(captchaInputClassnames)}>
                                <input
                                    type='text'
                                    placeholder=' '
                                    name='captcha_answer'
                                    autoCorrect='off'
                                    autoCapitalize='off'
                                    autoComplete='off'
                                    onInput={this.switchCaptchaEmptyState}
                                    ref={(input) => {
                                        this.captchaInput = input;
                                    }}
                                    className='passport-Input-Controller'
                                />

                                <span className='passport-Input-View'>
                                    <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.Captcha')}</span>
                                </span>
                            </label>
                        </div>
                    </div>
                )}

                {Boolean(!props.intranet && showPolicyTick) && (
                    <div className='passport-Domik-Form-Field'>
                        <label className='passport-Checkbox'>
                            <input
                                type='checkbox'
                                name='twoweeks'
                                value='no'
                                className='passport-Checkbox-Controller'
                            />
                            <span className='passport-Checkbox-View' />
                            <span className='passport-Checkbox-Label'>{i18n('OneDomik.Form.Label.Policy')}</span>
                        </label>
                    </div>
                )}

                <div className='passport-Domik-Form-Field'>
                    <button disabled={formIsSubmitted} type='submit' className='passport-Button'>
                        <span className='passport-Button-Content'>
                            <span className='passport-Button-Text'>{i18n('_AUTH_.Form.ButtonText.login')}</span>
                        </span>
                    </button>

                    {Boolean(
                        !props.intranet &&
                            (!allowedAuthMethods || (allowedAuthMethods && allowedAuthMethods.indexOf('magic') > -1))
                    ) && (
                        <button onClick={switchToMagic} type='button' className='passport-Button passport-Button_qr'>
                            <span className='passport-Button-Content' />
                        </button>
                    )}
                </div>
            </form>
        );
    }
}

Form.propTypes = {
    allowedAuthMethods: PropTypes.arrayOf(PropTypes.string),
    captcha: PropTypes.object,
    captchaRequired: PropTypes.bool,
    clearErrors: PropTypes.func,
    errors: PropTypes.string,
    csrf: PropTypes.string,
    form: PropTypes.object,
    formSettings: PropTypes.object,
    isMobile: PropTypes.bool,
    isMobileCaptcha: PropTypes.bool,
    isIE: PropTypes.bool,
    inputLogin: PropTypes.string,
    login: PropTypes.string,
    loginIsEmpty: PropTypes.bool,
    passwordIsEmpty: PropTypes.bool,
    captchaIsEmpty: PropTypes.bool,
    rfc: PropTypes.bool,
    focused: PropTypes.bool,
    method: PropTypes.string,
    retpath: PropTypes.string,
    realRetpath: PropTypes.string,
    formIsSubmitted: PropTypes.bool,
    fretpath: PropTypes.string,
    from: PropTypes.string,
    clean: PropTypes.string,
    passwordType: PropTypes.string,
    showPolicyTick: PropTypes.bool,
    isPhoneNumberExperiment: PropTypes.bool,
    intranet: PropTypes.bool,
    switchToMagic: PropTypes.func,
    track_id: PropTypes.string,
    lang: PropTypes.string,
    updateCaptchaValue: PropTypes.func,
    updateLoginValue: PropTypes.func,
    dispatch: PropTypes.func,
    submitCounter: PropTypes.number,
    updatePasswordValue: PropTypes.func
};
