import {
    domikIsLoading,
    processEmbAnswer,
    showAccounts,
    switchToMagic,
    switchToRfcTotp,
    switchToEmailCode,
    redirectToRetpath,
    processAnimationEnd,
    showMagicError,
    checkIframe,
    ONE_DOMIK_GOAL_PREFIX
} from './actions';
import passport from '@plibs/pclientjs/js/passport';
import metrics from '../metrics';

let store;

const oneDomik = {
    init(s) {
        const self = this;
        const element = document.getElementsByClassName('passport-ScreenBox-Content')[0];

        store = s;

        if (window.addEventListener) {
            window.addEventListener('message', self.onSuccess);
            element.addEventListener('transitionend', self.onProcessAnimationEnd, false);
        } else {
            window.attachEvent('onmessage', self.onSuccess);
            window.attachEvent('transitionend', self.onProcessAnimationEnd);
        }

        if (!window.location.origin) {
            window.location.origin = `${window.location.protocol}//${window.location.hostname}`;
        }

        window.response = function(url) {
            self.onSuccess({
                // eslint-disable-next-line compat/compat
                origin: location.origin,
                data: {
                    asyncAuth: url
                }
            });
        };
    },

    onProcessAnimationEnd(event) {
        store.dispatch(processAnimationEnd(event));
    },

    onSuccess(message) {
        let result;

        let errors;

        let metricsHeader;

        let method;

        if (message.origin !== location.origin) {
            return;
        }

        if (message.data.asyncAuth) {
            result = passport.util.getUrlParamsV2(message.data.asyncAuth);
            errors = result.errors;
            metricsHeader = result.source ? 'Экран саджеста' : 'Экран пустого домика';
            method = result.magic === 'yes' ? 'otp' : 'password';

            if (errors) {
                metrics.send([metricsHeader, 'Показ ошибки', errors]);
            }

            if (result.status === 'ok' && result.action === 'check') {
                store.dispatch(checkIframe(true));
                return;
            }

            if (result.status === 'ok' && !result.action) {
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_auth_success`);

                metrics.send([
                    metricsHeader,
                    'Успешный вход',
                    {
                        method
                    }
                ]);
            }

            if (result.status === 'ok' && result.action !== 'logout') {
                store.dispatch(redirectToRetpath());
            } else if (result.magic === 'yes') {
                if (result.source !== 'suggested') {
                    store.dispatch(switchToMagic());
                }

                if (errors === 'password.not_matched') {
                    errors = 'password.not_matched_2fa';
                }

                store.dispatch(showMagicError(errors));
            } else if (
                result.status === 'other' &&
                result.url &&
                !(['account.disabled', 'account.disabled_on_deletion'].indexOf(result.errors) > -1)
            ) {
                if (result.state === 'rfc_totp') {
                    store.dispatch(switchToRfcTotp());
                } else if (result.state === 'email_code') {
                    store.dispatch(switchToEmailCode());
                } else {
                    redirect(decodeURIComponent(result.url));
                }
            } else {
                store.dispatch(processEmbAnswer(result));

                if (result.status === 'ok') {
                    store.dispatch(showAccounts());
                }
            }

            store.dispatch(domikIsLoading(false));
        }
    }
};

function redirect(url) {
    const form = document.createElement('form');
    const element1 = document.createElement('input');

    form.method = 'GET';
    form.action = '/redirect';

    element1.value = url;
    element1.name = 'url';
    form.appendChild(element1);

    document.body.appendChild(form);

    form.submit();
    form.parentNode.removeChild(form);
}

export default oneDomik;
