import React, {Component} from 'react';
import PropTypes from 'prop-types';
import magic from './magic.js';

export class Magic extends Component {
    componentDidMount() {
        magic.start();
    }

    componentDidUpdate(prevProps) {
        if (prevProps.trackId !== this.props.trackId) {
            magic.restart();
        }
    }

    componentWillUnmount() {
        magic.stop();
    }

    render() {
        const {
            login,
            tld,
            isTouch,
            trackId,
            formSettings,
            switchModeToAddingAccount,
            method,
            isPhoneNumberExperiment
        } = this.props;

        const label = isPhoneNumberExperiment
            ? i18n('OneDomik.Form.Label.LoginOrPhoneNumber')
            : i18n('OneDomik.Form.Label.Login');

        function onClick(e) {
            e.preventDefault();
            switchModeToAddingAccount(true);
        }

        const spanStyle = {
            backgroundImage: `url('/auth/magic/code/?track_id=${trackId}')`
        };

        let appLinkDomain = ['com', 'co.il', 'fr'].indexOf(tld) > -1 ? 'com' : 'ru';

        if (tld === 'com.tr') {
            appLinkDomain = 'com.tr';
        }

        const strings = {
            header1: i18n('OneDomik.Magic.header.1'),
            header2: i18n('OneDomik.Magic.header.2'),
            header3: i18n('OneDomik.Magic.header.3'),
            linkTouch: 'https://mobile.yandex.ru/apps/key',
            linkDesktop: `https://yandex.${appLinkDomain}/support/passport/authorization/twofa.html`
        };

        const keyLink = `<a class='passport-Domik-Link' href='${isTouch ? strings.linkTouch : strings.linkDesktop}'>${
            strings.header2
        }</a>`;

        const intro = `${strings.header1.replace('%s', keyLink)}${strings.header3}`;

        function createMarkup() {
            return {__html: intro};
        }

        return (
            <div>
                {Boolean(method !== 'otp') && (
                    <h2 className='passport-Domik-Title'>
                        <span className='passport-Domik-Title-Part' dangerouslySetInnerHTML={createMarkup()} />
                    </h2>
                )}

                <form
                    method='post'
                    target={formSettings.target}
                    action={formSettings.handle}
                    className='passport-Domik-Form'
                >
                    {Boolean(login) && <input type='hidden' name='login' value={login} />}

                    <input type='hidden' name='retpath' value={`${formSettings.retpath}`} />
                    <input type='hidden' name='idkey' value={trackId} />
                    <input type='hidden' name='extended' value='1' />
                    <input type='hidden' name='one' value='1' />
                    <input type='hidden' name='twoweeks' value='yes' />

                    {Boolean(method !== 'otp') && (
                        <div className='qr-code'>
                            <div className='qr-code__i' style={spanStyle} />
                        </div>
                    )}

                    {Boolean(method === 'otp') && (
                        <div>
                            {Boolean(!login) && (
                                <div className='passport-Domik-Form-Field'>
                                    <label className='passport-Input'>
                                        <input
                                            name='login'
                                            type='text'
                                            placeholder=' '
                                            className='passport-Input-Controller'
                                        />
                                        <span className='passport-Input-View'>
                                            <span className='passport-Input-Label'>{label}</span>
                                        </span>
                                    </label>
                                </div>
                            )}

                            <div className='passport-Domik-Form-Field'>
                                <label className='passport-Input'>
                                    <input
                                        name='password'
                                        type='password'
                                        placeholder=' '
                                        className='passport-Input-Controller'
                                    />
                                    <span className='passport-Input-View'>
                                        <span className='passport-Input-Label'>{i18n('OneDomik.Form.Label.OTP')}</span>
                                    </span>
                                </label>
                            </div>

                            <div className='passport-Domik-Form-Field'>
                                <button type='submit' className='passport-Button'>
                                    <span className='passport-Button-Content'>
                                        <span className='passport-Button-Text'>
                                            {i18n('_AUTH_.Form.ButtonText.login')}
                                        </span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    )}

                    {Boolean(method !== 'otp') && (
                        <div>
                            {i18n('OneDomik.Magic.footer.1')}{' '}
                            <a href='' className='passport-Domik-Link' onClick={onClick}>
                                {i18n('OneDomik.Magic.footer.2')}
                            </a>
                        </div>
                    )}
                </form>
            </div>
        );
    }
}

Magic.propTypes = {
    login: PropTypes.string,
    retpath: PropTypes.string,
    tld: PropTypes.string,
    formSettings: PropTypes.object,
    trackId: PropTypes.string,
    isTouch: PropTypes.bool,
    isPhoneNumberExperiment: PropTypes.bool,
    switchModeToAddingAccount: PropTypes.func,
    method: PropTypes.string
};
