import find from 'lodash/find';
import assign from 'lodash/assign';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {bindActionCreators} from 'redux';
import {connect} from 'react-redux';
import classnames from 'classnames';
import {
    doModeAnimation,
    switchModeToAddingAccount,
    switchModeToEdit,
    switchToMagic,
    switchToEmailCode,
    expandError,
    clearErrors,
    updateLoginValue,
    updatePasswordValue,
    updateCaptchaValue,
    submitIframeCheck,
    ONE_DOMIK_GOAL_PREFIX
} from './actions';
import {startSocialAuth} from './broker';
import {ConnectedAccountList} from './account_list/account_list.jsx';
import {SocialBlock, ExtendedSocialBlock} from './social/social.jsx';
import {Magic} from './magic/magic.jsx';
import {Message} from './message/message.jsx';
import {Form} from './form/form.jsx';
import {Errors} from './errors/errors.jsx';
import {CurrentAccount} from './current_account/current_account.jsx';
import {SwitchLink} from './switch/switch.jsx';
import metrics from '../metrics';
import {Spin} from '@components/Spin';

const taglines = {
    appmetrica: i18n('OneDomikCustoms.Tagline.appmetrica.welcome'),
    audience: i18n('OneDomikCustoms.Tagline.audience.welcome'),
    connect: i18n('OneDomikCustoms.Tagline.connect.welcome'),
    contest: i18n('OneDomikCustoms.Tagline.contest.welcome'),
    serp_disk: i18n('OneDomikCustoms.Tagline.serp.serp_disk'),
    serp_ugc: i18n('OneDomikCustoms.Tagline.serp.serp_ugc'),
    serp_default: i18n('OneDomikCustoms.tagline.serp.serp_default'),
    toloka: i18n('OneDomikCustoms.Tagline.toloka.welcome'),
    telephony: i18n('OneDomikCustoms.Tagline.telephony.welcome'),
    music: i18n('OneDomikCustoms.Tagline.music.music_default'),
    health: i18n('OneDomikCustoms.Tagline.health.promo'),
    news_welcome1: i18n('OneDomikCustoms.Tagline.news.welcome1'),
    news_welcome2: i18n('OneDomikCustoms.Tagline.news.welcome2'),
    lyceum: i18n('OneDomikCustoms.Tagline.lyceum.welcome'),
    mail_exp: i18n('OneDomikCustoms.Tagline.mail.exp'),
    money_offer: i18n('OneDomikCustoms.Tagline.money.money_offer'),
    maps_favorites: i18n('OneDomikCustoms.Tagline.maps.maps_favorites'),
    maps_feedback: i18n('OneDomikCustoms.Tagline.maps.maps_feedback'),
    maps_reviews: i18n('OneDomikCustoms.Tagline.maps.maps_reviews'),
    mapsconstructor_new: i18n('OneDomikCustoms.Tagline.maps.mapsconstructor_new'),
    money_payment: i18n('OneDomikCustoms.Tagline.money.money_payment'),
    money_card: i18n('OneDomikCustoms.Tagline.money.money_card'),
    video: i18n('OneDomikCustoms.Tagline.video.welcome'),
    video_myvideo_add_new: i18n('OneDomikCustoms.Tagline.video.video_myvideo_add_new'),
    tune: i18n('OneDomikCustoms.Tagline.tune.welcome'),
    'disk_public-touch-copy': i18n('OneDomikCustoms.Tagline.disk.disk_public-touch-copy'),
    'disk_public-android-copy': i18n('OneDomikCustoms.Tagline.disk.disk_public-android-copy'),
    'disk_public-touch-copy-limit': i18n('OneDomikCustoms.Tagline.disk.disk_public-touch-copy-limit'),
    'disk_public-touch-comment': i18n('OneDomikCustoms.Tagline.disk.disk_public-touch-comment'),
    'disk_public-android-comment': i18n('OneDomikCustoms.Tagline.disk.disk_public-android-comment'),
    market_desktop_review: i18n('OneDomikCustoms.Tagline.market.market_desktop_review'),
    market_desktop_wishlist: i18n('OneDomikCustoms.Tagline.market.market_desktop_wishlist'),
    market_desktop_compare: i18n('OneDomikCustoms.Tagline.market.market_desktop_compare'),
    market_desktop_header: i18n('OneDomikCustoms.Tagline.market.market_desktop_header'),
    market_desktop_forum: i18n('OneDomikCustoms.Tagline.market.market_desktop_forum'),
    market_desktop_comment: i18n('OneDomikCustoms.Tagline.market.market_desktop_comment'),
    market_desktop_checkout: i18n('OneDomikCustoms.Tagline.market.market_desktop_checkout'),
    market_desktop_reviews: i18n('OneDomikCustoms.Tagline.market.market_desktop_reviews'),
    market_desktop_orders: i18n('OneDomikCustoms.Tagline.market.market_desktop_orders'),
    market_desktop_wishlist_save: i18n('OneDomikCustoms.Tagline.market.market_desktop_wishlist_save'),
    market_desktop_compare_save: i18n('OneDomikCustoms.Tagline.market.market_desktop_compare_save'),
    zen_pubs: i18n('OneDomikCustoms.Tagline.zen.zen_pubs'),
    znatoki: i18n('OneDomikCustoms.Tagline.znatoki.welcome'),
    passport_device: i18n('OneDomikCustoms.Tagline.passport.passport_device'),
    plus_gift: i18n('OneDomikCustoms.Tagline.plus.welcome'),
    plus_1year: i18n('OneDomikCustoms.Tagline.plus.plus_1year'),
    market_cashback: i18n('OneDomikCustoms.Tagline.market_cashback.welcome')
};

function mapDispatchToProps(dispatch) {
    const actionCreators = {
        doModeAnimation,
        switchModeToAddingAccount,
        switchModeToEdit,
        switchToMagic,
        switchToEmailCode,
        startSocialAuth,
        expandError,
        updatePasswordValue,
        updateLoginValue,
        updateCaptchaValue,
        submitIframeCheck,
        clearErrors
    };

    return assign(bindActionCreators(actionCreators, dispatch), {dispatch});
}

function mapStateToProps(state) {
    const {
        authorizedAccounts,
        authorizedAccountsDefaultUid,
        captchaRequired,
        csrf_token,
        embAnswer,
        errors,
        focused,
        form,
        submitCounter,
        inputLogins,
        isExpanded,
        loading,
        loginIsEmpty,
        passwordIsEmpty,
        captchaIsEmpty,
        formIsSubmitted,
        formIsUpgraded,
        needEmpty,
        passwordType,
        suggestedAccounts,
        track_id,
        unitedAccounts
    } = state.one_domik;

    const {
        backpath,
        clean,
        csrf,
        experiments,
        fretpath,
        from,
        embeddedauth_url,
        editUrl,
        auth_url,
        loginStatusRetpath,
        registration_url,
        restoration_url,
        retpath,
        sessguardIsEnabled,
        yandex_url
    } = state.common;

    const providers = state.social.providers;
    const captcha = state.captcha;
    const {socialExtended, socialScope, tagline, display, minimal} = state.customs;

    const {isTouch, isMobile, isTablet} = state.settings.ua;

    const isIE = ['MSIE', 'Edge'].indexOf(state.settings.ua.BrowserName) > -1;

    let {processedAccount, mode} = state.one_domik;

    const {avatar, tld, lang, intranet} = state.settings;

    const defaultAccount = find(authorizedAccounts, (o) => o.uid === authorizedAccountsDefaultUid);

    if (!mode) {
        if (authorizedAccounts.length) {
            mode = 'edit';
        } else {
            mode = 'addingAccount';
        }
    }

    if (!processedAccount && suggestedAccounts.length && !needEmpty) {
        processedAccount = unitedAccounts[suggestedAccounts[0].account.uid];
    }

    if (needEmpty) {
        processedAccount = null;
    }

    if (form.login) {
        processedAccount = null;

        if (suggestedAccounts.length) {
            suggestedAccounts.forEach(function(acc) {
                const account = acc.account;

                if (account && (account.login === form.login || account.display_login === form.login)) {
                    processedAccount = unitedAccounts[account.uid];
                }
            });
        }
    }

    const method = (processedAccount && processedAccount.preferred_auth_method) || 'password';

    const formSettings = {
        target: '_self',
        handle: state.common.auth_url,
        retpath
    };

    const inputLogin = (processedAccount && inputLogins && inputLogins[processedAccount.uid]) || null;

    if (formIsUpgraded) {
        formSettings.target = 'iframe';
        formSettings.handle = state.common.embeddedauth_url;
        formSettings.retpath = `${loginStatusRetpath}?method=${method}`;
    }

    return {
        account: defaultAccount,
        authorizedAccounts,
        avatar,
        backpath,
        clean,
        captcha,
        captchaIsEmpty,
        captchaRequired,
        csrf,
        csrf_token,
        embAnswer,
        editUrl,
        auth_url,
        embeddedauth_url,
        errors,
        flagsString: experiments.flagsString,
        flags: experiments.flags,
        focused,
        form,
        formSettings,
        formIsSubmitted,
        fretpath,
        from,
        inputLogin,
        isExpanded,
        isIE,
        isMobile,
        isMobileCaptcha: Boolean(isMobile || isTablet),
        isTouch,
        intranet,
        lang,
        loading,
        loginIsEmpty,
        loginStatusRetpath,
        method,
        minimal,
        mode,
        passwordIsEmpty,
        passwordType,
        processedAccount,
        providers,
        registration_url,
        restoration_url,
        retpath,
        sessguardIsEnabled,
        socialExtended,
        socialScope,
        submitCounter,
        suggestedAccounts,
        display,
        tagline,
        tld,
        track_id,
        unitedAccounts,
        yandex_url
    };
}

class OneDomik extends Component {
    constructor(props) {
        super(props);

        this.sendMetrics = this.sendMetrics.bind(this);
        this.backClickHandler = this.backClickHandler.bind(this);
    }

    backClickHandler(e) {
        e.preventDefault();

        if (this.props.mode === 'magic') {
            this.props.switchModeToAddingAccount(true);
        } else {
            this.props.switchModeToEdit();
        }
    }

    componentDidMount() {
        const mode = this.props.mode;
        const authorizedAccounts = this.props.authorizedAccounts || [];
        const suggestedAccounts = this.props.suggestedAccounts || [];
        const unitedAccounts = this.props.unitedAccounts || {};
        const sessguardIsEnabled = this.props.sessguardIsEnabled;

        if (!sessguardIsEnabled) {
            this.props.submitIframeCheck();
        }

        if (mode === 'email_code') {
            this.props.switchToEmailCode();
        }

        if (this.props.flagsString) {
            metrics.goal(this.props.flagsString);
        }

        if (mode === 'addingAccount') {
            if (!this.props.processedAccount) {
                metrics.send(['Экран пустого домика', 'Показ']);
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_empty_form`);
            }

            if (this.props.processedAccount) {
                metrics.send([
                    'Экран саджеста',
                    'Показ',
                    {
                        method: this.props.method
                    }
                ]);
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_suggest`);
            }
        }

        if (mode === 'edit') {
            metrics.send([
                'Экран списка саджестов',
                'Показ списка саджестов',
                {
                    authorized: authorizedAccounts.length,
                    suggested: suggestedAccounts.length,
                    united: Object.keys(unitedAccounts).length
                }
            ]);

            if (!authorizedAccounts.length) {
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_only_suggests_list`);
            }

            if (authorizedAccounts.length) {
                metrics.goal(`${ONE_DOMIK_GOAL_PREFIX}_show_accounts_list`);
            }
        }
    }

    sendMetrics(event) {
        const visitParams = event.currentTarget.dataset.metrics;

        let metricsHeader = 'Экран пустого домика';

        if (this.props.processedAccount) {
            metricsHeader = 'Экран саджеста';
        }

        if (this.props.mode === 'edit') {
            metricsHeader = 'Экран списка саджестов';
        }

        if (visitParams) {
            metrics.send([metricsHeader, visitParams]);
        }
    }

    render() {
        const props = this.props;
        const method = props.method;
        const isPhoneNumberExperiment = props.flags.indexOf('phone_alias_as_login_exp') > -1;

        const formClassNames = {
            'passport-ScreenBox-Item': true,
            'passport-ScreenBox-Item_current': props.mode === 'addingAccount'
        };

        const listClassNames = {
            'passport-ScreenBox-Item': true,
            'passport-ScreenBox-Item_current': props.mode === 'edit'
        };

        const magicClassNames = {
            'passport-ScreenBox-Item': true,
            'passport-ScreenBox-Item_current': props.mode === 'magic' || props.mode === 'rfc_totp'
        };

        const emailCodeClassNames = {
            'passport-ScreenBox-Item': true,
            'passport-ScreenBox-Item_current': props.mode === 'email_code'
        };

        const domikClassNames = {
            'passport-Domik': true,
            'passport-Domik_theme_minimal': props.minimal
        };

        const passportPageContentClassNames = {
            'passport-Page-Content': true,
            'passport-Page-Content_theme_minimal': props.minimal
        };

        const commonProps = {
            allowedAuthMethods: props.processedAccount && props.processedAccount.allowed_auth_methods,
            captchaIsEmpty: props.captchaIsEmpty,
            captcha: props.captcha,
            captchaRequired: props.captchaRequired,
            clearErrors: () => props.clearErrors(),
            csrf: props.csrf,
            dispatch: props.dispatch,
            errors: props.errors,
            focused: props.focused,
            form: props.form,
            formIsSubmitted: props.formIsSubmitted,
            formSettings: props.formSettings,
            inputLogin: props.inputLogin,
            isIE: props.isIE,
            isMobile: props.isMobile,
            isMobileCaptcha: props.isMobileCaptcha,
            intranet: props.intranet,
            lang: props.lang,
            loginIsEmpty: props.loginIsEmpty,
            passwordIsEmpty: props.passwordIsEmpty,
            login: props.processedAccount && (props.processedAccount.displayLogin || props.processedAccount.login),
            passwordType: props.passwordType,
            realRetpath: props.retpath,
            retpath: props.loginStatusRetpath,
            showPolicyTick: props.authorizedAccounts.length === 0,
            submitCounter: props.submitCounter,
            switchToMagic: () => props.switchToMagic(),
            track_id: (props.embAnswer && props.embAnswer.idkey) || props.track_id,
            updateCaptchaValue: props.updateCaptchaValue,
            updateLoginValue: props.updateLoginValue,
            from: props.from,
            fretpath: props.fretpath,
            clean: props.clean,
            updatePasswordValue: props.updatePasswordValue,
            isPhoneNumberExperiment
        };

        domikClassNames[`passport-Domik_mode_${props.mode}`] = true;

        return (
            <div className={classnames(passportPageContentClassNames)}>
                {Boolean(props.loading) && (
                    <div className='passport-Page-loading'>
                        <Spin size='m' progress={true} />
                    </div>
                )}
                <div className={classnames(domikClassNames)}>
                    <h1 className='passport-Logo'>
                        <a href={props.yandex_url}>
                            {['en', 'fr', 'tr', 'fi', 'id'].indexOf(props.lang) > -1 ? (
                                <span className='passport-Icon passport-Icon_yandex_en' />
                            ) : (
                                <span className='passport-Icon passport-Icon_yandex_ru' />
                            )}
                        </a>
                        {Boolean(
                            (props.mode !== 'email_code' &&
                                props.mode !== 'edit' &&
                                Object.keys(props.unitedAccounts).length > 0) ||
                                props.mode === 'magic'
                        ) && (
                            <a
                                className='passport-Domik-Return'
                                data-metrics='Клик на Назад'
                                onMouseDown={this.sendMetrics}
                                onClick={this.backClickHandler}
                            />
                        )}
                    </h1>

                    {Boolean(props.mode !== 'edit' && props.tagline) && <Message text={taglines[props.tagline]} />}

                    {Boolean(props.mode === 'email_code') && !props.tagline && (
                        <Message text={i18n('OneDomik.AuthMailCode.title')} />
                    )}

                    {(!props.processedAccount || props.mode === 'email_code') && (
                        <Errors code={props.errors} expandError={props.expandError} isExpanded={props.isExpanded} />
                    )}

                    <div className='passport-ScreenBox passport-Domik-Content passport-Domik-Content_wide'>
                        <div className='passport-ScreenBox-Content'>
                            <div className={classnames(listClassNames)}>
                                <div className='passport-ScreenBox-Item-Content'>
                                    <div className='passport-Domik-Content'>
                                        {Boolean(props.mode === 'edit') && (
                                            <ConnectedAccountList
                                                isTouch={props.isTouch}
                                                onMouseDown={this.sendMetrics}
                                                switchLinkOnclick={() => props.switchModeToAddingAccount(true)}
                                            />
                                        )}
                                    </div>
                                </div>
                            </div>
                            <div className={classnames(formClassNames)}>
                                <div className='passport-ScreenBox-Item-Content'>
                                    <div className='passport-Domik-Content'>
                                        {Boolean(props.mode === 'addingAccount') && (
                                            <div>
                                                {Boolean(props.processedAccount) && (
                                                    <div>
                                                        <CurrentAccount
                                                            account={props.processedAccount}
                                                            avatar={props.avatar}
                                                        />

                                                        {Boolean(Object.keys(props.unitedAccounts).length > 1) && (
                                                            <SwitchLink
                                                                onMouseDown={this.sendMetrics}
                                                                onClick={() => props.switchModeToEdit()}
                                                                linkText={i18n('OneDomik.ChooseOtherAccount.link')}
                                                            />
                                                        )}

                                                        {Boolean(Object.keys(props.unitedAccounts).length === 1) && (
                                                            <SwitchLink
                                                                onMouseDown={this.sendMetrics}
                                                                onClick={() => props.switchModeToAddingAccount(true)}
                                                                linkText={i18n('OneDomik.OtherAccount.link')}
                                                            />
                                                        )}

                                                        <Errors
                                                            code={props.errors}
                                                            expandError={props.expandError}
                                                            isExpanded={props.isExpanded}
                                                        />

                                                        {Boolean(
                                                            method === 'password' ||
                                                                method === 'otp' ||
                                                                method === 'magic'
                                                        ) && <Form method={method} {...commonProps} />}

                                                        {Boolean(
                                                            [
                                                                'social_gg',
                                                                'social_fb',
                                                                'social_tw',
                                                                'social_mr',
                                                                'social_vk',
                                                                'social_ok'
                                                            ].indexOf(method) > -1
                                                        ) && (
                                                            <div>
                                                                {Boolean(
                                                                    props.processedAccount.allowed_auth_methods &&
                                                                        // eslint-disable-next-line max-len
                                                                        props.processedAccount.allowed_auth_methods.indexOf(
                                                                            'password'
                                                                        ) > -1
                                                                ) && <Form method='password' {...commonProps} />}

                                                                <SocialBlock
                                                                    showInfo={false}
                                                                    startSocialAuth={props.startSocialAuth}
                                                                    onMouseDown={this.sendMetrics}
                                                                    socialScope={props.socialScope}
                                                                    providers={props.providers}
                                                                    method={method}
                                                                />
                                                            </div>
                                                        )}
                                                    </div>
                                                )}

                                                {Boolean(!props.processedAccount) && (
                                                    <div>
                                                        <Form {...commonProps} />
                                                        {Boolean(!props.minimal && !props.intranet) &&
                                                            (props.socialExtended ? (
                                                                <ExtendedSocialBlock
                                                                    showInfo={true}
                                                                    providers={props.providers}
                                                                    socialScope={props.socialScope}
                                                                    onMouseDown={this.sendMetrics}
                                                                    startSocialAuth={props.startSocialAuth}
                                                                />
                                                            ) : (
                                                                <SocialBlock
                                                                    showInfo={true}
                                                                    providers={props.providers}
                                                                    socialScope={props.socialScope}
                                                                    onMouseDown={this.sendMetrics}
                                                                    startSocialAuth={props.startSocialAuth}
                                                                />
                                                            ))}
                                                    </div>
                                                )}
                                            </div>
                                        )}
                                    </div>
                                </div>
                            </div>
                            <div className={classnames(magicClassNames)}>
                                <div className='passport-ScreenBox-Item-Content'>
                                    <div className='passport-Domik-Content'>
                                        {Boolean(props.mode === 'rfc_totp') && (
                                            <Form method='otp' rfc={true} {...commonProps} />
                                        )}
                                        {Boolean(props.mode === 'magic') && (
                                            <Magic
                                                doModeAnimation={() => props.doModeAnimation('magic')}
                                                formSettings={props.formSettings}
                                                retpath={props.loginStatusRetpath}
                                                realRetpath={props.retpath}
                                                isTouch={props.isTouch}
                                                tld={props.tld}
                                                isPhoneNumberExperiment={props.isPhoneNumberExperiment}
                                                switchModeToAddingAccount={() => props.switchModeToAddingAccount(true)}
                                                trackId={props.track_id}
                                            />
                                        )}
                                    </div>
                                </div>
                            </div>

                            <div className={classnames(emailCodeClassNames)}>
                                <div className='passport-ScreenBox-Item-Content'>
                                    <div className='passport-Domik-Content'>
                                        {Boolean(props.mode === 'email_code') && (
                                            <Form method='email_code' {...commonProps} />
                                        )}
                                    </div>
                                </div>
                            </div>
                        </div>

                        {Boolean(!props.intranet) && (
                            <ul className='passport-Domik-Footer'>
                                <li className='passport-Domik-Footer-Item'>
                                    {props.processedAccount && props.mode === 'addingAccount' ? (
                                        <a
                                            data-metrics='Клик на восстановление'
                                            onMouseDown={this.sendMetrics}
                                            href={props.restoration_url}
                                            className='passport-Domik-Link passport-Domik-Footer-Link'
                                        >
                                            {i18n('OneDomik.Footer.Link.RestorePassword')}
                                        </a>
                                    ) : (
                                        <a
                                            data-metrics='Клик на восстановление'
                                            onMouseDown={this.sendMetrics}
                                            href={props.restoration_url}
                                            className='passport-Domik-Link passport-Domik-Footer-Link'
                                        >
                                            {i18n('OneDomik.Footer.Link.Restoration')}
                                        </a>
                                    )}
                                </li>
                                {Boolean(!props.minimal) && (
                                    <li className='passport-Domik-Footer-Item'>
                                        <a
                                            data-metrics='Клик на регистрацию'
                                            onMouseDown={this.sendMetrics}
                                            href={props.registration_url}
                                            className='passport-Domik-Link passport-Domik-Footer-Link'
                                        >
                                            {i18n('OneDomik.Footer.Link.Registration')}
                                        </a>
                                    </li>
                                )}
                            </ul>
                        )}
                    </div>
                </div>

                <iframe className='passport-Domik-Iframe' name='iframe' src='about:blank' />
            </div>
        );
    }
}

OneDomik.propTypes = {
    account: PropTypes.object,
    authorizedAccounts: PropTypes.arrayOf(PropTypes.object),
    avatar: PropTypes.object,
    captcha: PropTypes.object,
    captchaRequired: PropTypes.bool,
    csrf_token: PropTypes.string,
    embAnswer: PropTypes.object,
    errors: PropTypes.string,
    flagsString: PropTypes.string,
    form: PropTypes.object,
    embeddedauth_url: PropTypes.string,
    auth_url: PropTypes.string,
    intranet: PropTypes.bool,
    isExpanded: PropTypes.bool,
    isMobile: PropTypes.bool,
    isMobileCaptcha: PropTypes.bool,
    isTouch: PropTypes.bool,
    lang: PropTypes.string,
    loading: PropTypes.bool,
    loginStatusRetpath: PropTypes.string,
    method: PropTypes.string,
    mode: PropTypes.string,
    processedAccount: PropTypes.object,
    registration_url: PropTypes.string,
    restoration_url: PropTypes.string,
    retpath: PropTypes.string,
    socialExtended: PropTypes.bool,
    switchModeToAddingAccount: PropTypes.func,
    switchModeToEdit: PropTypes.func,
    submitIframeCheck: PropTypes.func,
    suggestedAccounts: PropTypes.arrayOf(PropTypes.object),
    display: PropTypes.string,
    minimal: PropTypes.bool,
    track_id: PropTypes.string,
    unitedAccounts: PropTypes.object,
    yandex_url: PropTypes.string,
    switchToEmailCode: PropTypes.func,
    submitCounter: PropTypes.func,
    switchToMagic: PropTypes.func,
    updateCaptchaValue: PropTypes.func,
    updateLoginValue: PropTypes.func,
    updatePasswordValue: PropTypes.func,
    clearErrors: PropTypes.func,
    expandError: PropTypes.func,
    startSocialAuth: PropTypes.func,
    doModeAnimation: PropTypes.func,
    dispatch: PropTypes.func.isRequired,
    flags: PropTypes.array,
    captchaIsEmpty: PropTypes.bool,
    sessguardIsEnabled: PropTypes.bool,
    isIE: PropTypes.bool,
    loginIsEmpty: PropTypes.bool,
    passwordIsEmpty: PropTypes.bool,
    focused: PropTypes.bool,
    formIsSubmitted: PropTypes.bool,
    clean: PropTypes.bool,
    isPhoneNumberExperiment: PropTypes.bool,
    csrf: PropTypes.string,
    from: PropTypes.string,
    fretpath: PropTypes.string,
    tagline: PropTypes.string,
    tld: PropTypes.string,
    passwordType: PropTypes.string,
    formSettings: PropTypes.object,
    socialScope: PropTypes.object,
    inputLogin: PropTypes.string,
    providers: PropTypes.array
};

const ConnectedOneDomik = connect(mapStateToProps, mapDispatchToProps)(OneDomik);

export default ConnectedOneDomik;
