import {
    SHOW_FORM,
    SHOW_ACCOUNTS,
    SHOW_ACCOUNTS_SUCCESS,
    SHOW_ACCOUNTS_FAIL,
    CHANGE_ACTIVE_ACCOUNT,
    // LOGOUT_ACCOUNT,
    LOGIN_SUGGESTED_ACCOUNT,
    SWITCH_MODE_TO_ADDING_ACCOUNT,
    SWITCH_MODE_TO_EDIT,
    SWITCH_TO_MAGIC,
    SWITCH_TO_RFC_TOTP,
    SWITCH_PASSWORD_TYPE,
    SWITCH_LOGIN_EMPTY_STATE,
    SWITCH_PASSWORD_EMPTY_STATE,
    SWITCH_CAPTCHA_EMPTY_STATE,
    SWITCH_FORM_SUBMITTED_STATE,
    SHOW_MAGIC_ERROR,
    PROCESS_EMB_ANSWER,
    GO_TO_URL,
    EXPAND_ERROR,
    GET_TRACK_AND_CSRF,
    CLEAR_ERRORS,
    UPDATE_LOGIN_VALUE,
    UPDATE_PASSWORD_VALUE,
    UPDATE_CAPTCHA_VALUE,
    UPDATE_TOKENS_SUCCESS,
    DO_MODE_ANIMATION,
    PROCESS_ANIMATION_END,
    CHECK_IFRAME,
    TOGGLE_ACCOUNT_LIST_EDITING,
    INPUT_LOGIN_SUCCESS,
    DOMIK_IS_LOADING,
    SWITCH_TO_EMAIL_CODE,
    SUBMIT_EMAIL_CODE_FAIL,
    SUBMIT_EMAIL_CODE_SUCCESS
} from './actions';

export default function oneDomik(state = {}, action) {
    switch (action.type) {
        case CHECK_IFRAME: {
            return $.extend({}, state, {
                formIsUpgraded: action.isPassed
            });
        }
        case UPDATE_LOGIN_VALUE: {
            return $.extend({}, state, {
                form: {
                    login: action.value,
                    captcha_answer: state.form.captcha_answer,
                    pdd_domain: state.form.pdd_domain,
                    password: state.form.password
                }
            });
        }
        case UPDATE_PASSWORD_VALUE: {
            return $.extend({}, state, {
                form: {
                    password: action.value,
                    captcha_answer: state.form.captcha_answer,
                    pdd_domain: state.form.pdd_domain,
                    login: state.form.login
                }
            });
        }
        case UPDATE_CAPTCHA_VALUE: {
            return $.extend({}, state, {
                form: {
                    password: state.form.password,
                    captcha_answer: action.value,
                    pdd_domain: state.form.pdd_domain,
                    login: state.form.login
                }
            });
        }
        case SWITCH_PASSWORD_TYPE: {
            return $.extend({}, state, {
                passwordType: action.passwordType
            });
        }
        case SWITCH_LOGIN_EMPTY_STATE: {
            return $.extend({}, state, {
                loginIsEmpty: action.isEmpty
            });
        }
        case SWITCH_PASSWORD_EMPTY_STATE: {
            return $.extend({}, state, {
                passwordIsEmpty: action.isEmpty
            });
        }
        case SWITCH_CAPTCHA_EMPTY_STATE: {
            return $.extend({}, state, {
                captchaIsEmpty: action.isEmpty
            });
        }
        case SWITCH_FORM_SUBMITTED_STATE: {
            return $.extend({}, state, {
                formIsSubmitted: action.isSubmitted
            });
        }
        case UPDATE_TOKENS_SUCCESS: {
            return $.extend({}, state, {
                track_id: action.track_id,
                csrf_token: action.csrf_token
            });
        }
        case DO_MODE_ANIMATION:
            return $.extend({}, state, {
                animationMode: action.mode
            });
        case PROCESS_ANIMATION_END:
            return $.extend({}, state, {
                focused: state.mode !== 'edit'
            });
        case TOGGLE_ACCOUNT_LIST_EDITING:
            return $.extend({}, state, {
                isAccountListEditing: action.enable
            });
        case SWITCH_MODE_TO_ADDING_ACCOUNT:
            return $.extend({}, state, {
                mode: 'addingAccount',
                errors: null,
                isExpanded: false,
                needEmpty: action.needEmpty,
                captchaRequired: null,
                form: {
                    login: '',
                    password: '',
                    pdd_domain: state.form.pdd_domain,
                    captcha_answer: ''
                }
            });
        case SWITCH_MODE_TO_EDIT:
            return $.extend({}, state, {
                mode: 'edit',
                needEmpty: false,
                errors: null,
                isExpanded: false,
                captchaRequired: null,
                focused: false,
                processedAccount: null,
                passwordType: 'password',
                form: {
                    login: '',
                    password: '',
                    pdd_domain: state.form.pdd_domain,
                    captcha_answer: ''
                }
            });
        case SWITCH_TO_MAGIC:
            return $.extend({}, state, {
                mode: 'magic',
                errors: null,
                isExpanded: false,
                passwordType: 'password',
                focused: false,
                captchaRequired: null
            });
        case SWITCH_TO_RFC_TOTP:
            return $.extend({}, state, {
                mode: 'rfc_totp',
                errors: null,
                isExpanded: false,
                passwordType: 'password',
                focused: false,
                formIsSubmitted: false,
                captchaRequired: null
            });
        case SWITCH_TO_EMAIL_CODE:
            return $.extend({}, state, {
                mode: 'email_code',
                errors: null,
                isExpanded: false,
                passwordType: 'password',
                focused: false,
                formIsSubmitted: false,
                captchaRequired: null,
                loading: true
            });
        case GET_TRACK_AND_CSRF:
            return $.extend({}, state, {
                csrf_token: action.csrf_token,
                track_id: action.track_id
            });
        case SHOW_FORM:
            return $.extend({}, state, {
                requestPassword: action.show,
                passwordNotMatched: false
            });
        case CLEAR_ERRORS:
            return $.extend({}, state, {
                errors: null,
                isExpanded: false
            });
        case EXPAND_ERROR:
            return $.extend({}, state, {
                isExpanded: true
            });
        case CHANGE_ACTIVE_ACCOUNT:
            return $.extend({}, state, {
                authorizedAccountsDefaultUid: action.uid
            });
        case LOGIN_SUGGESTED_ACCOUNT:
            return $.extend({}, state, {
                method: action.account.preferred_auth_method,
                processedAccount: action.account,
                mode: 'addingAccount'
            });
        case PROCESS_EMB_ANSWER: {
            const {errors, status} = action.data;

            let mode = 'addingAccount';

            if (status === 'ok' || status === 'action-not-required') {
                mode = 'edit';
            } else if (action.data.state === 'rfc_totp' || action.data.method === 'rfc_totp') {
                mode = 'rfc_totp';
            } else if (action.data.state === 'email_code' || action.data.method === 'email_code') {
                mode = 'email_code';
            }

            return $.extend({}, state, {
                embAnswer: action.data,
                submitCounter: state.submitCounter + 1,
                errors: status === 'internal-exception' ? 'internal' : errors,
                captchaRequired: ['captcha.required', 'captcha.invalid'].indexOf(errors) > -1,
                formIsSubmitted: false,
                mode,
                processedAccount: action.data.status === 'ok' ? null : state.processedAccount,
                track_id: action.data.idkey
            });
        }
        case GO_TO_URL:
            return $.extend({}, state, {
                urlToRedirect: action.data.url
            });
        case SHOW_ACCOUNTS:
            return $.extend({}, state, {
                loading: true
            });
        case SUBMIT_EMAIL_CODE_SUCCESS:
            return $.extend({}, state, {
                loading: false
            });
        case SUBMIT_EMAIL_CODE_FAIL:
            return $.extend({}, state, {
                errors: action.errors,
                loading: false
            });
        case SHOW_ACCOUNTS_SUCCESS:
            return $.extend({}, state, action.accounts, {
                loading: false,
                mode: Object.keys(action.accounts.unitedAccounts).length !== 0 ? 'edit' : 'addingAccount',
                focused: false,
                errors: null,
                isExpanded: false,
                isAccountListEditing: state.isAccountListEditing
            });
        case SHOW_ACCOUNTS_FAIL: {
            const errors = {};

            return $.extend({}, state, {
                errors,
                loading: false
            });
        }
        case SHOW_MAGIC_ERROR: {
            return $.extend({}, state, {
                errors: action.errors,
                captchaRequired: ['captcha.required', 'captcha.invalid'].indexOf(action.errors) > -1
            });
        }
        case INPUT_LOGIN_SUCCESS: {
            return $.extend({}, state, {
                inputLogins: $.extend({}, state.inputLogins, action.inputLogin)
            });
        }
        case DOMIK_IS_LOADING: {
            return $.extend({}, state, {
                loading: action.loading
            });
        }
        default:
            return state;
    }
}
