import React, {Component} from 'react';
import PropTypes from 'prop-types';

const networks = {
    social_gg: {
        provider: 'gg',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.gg'))
    },
    social_tw: {
        provider: 'tw',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.tw'))
    },
    social_fb: {
        provider: 'fb',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.fb'))
    },
    social_mr: {
        provider: 'mr',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.mr'))
    },
    social_vk: {
        provider: 'vk',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.vk'))
    },
    social_ok: {
        provider: 'ok',
        name: i18n('OneDomik.SocialBlock.BigButton.common').replace('%s', i18n('_AUTH_.SocialBlock.BigButton.ok'))
    }
};

class SocialBlockBigButton extends Component {
    render() {
        const {name, provider, onMouseDown, onClick} = this.props;

        return (
            <li className='passport-Domik-SocialNetworks-Field'>
                <button
                    data-metrics={`Начало соцавторизации: ${provider}`}
                    onMouseDown={onMouseDown}
                    onClick={onClick}
                    type='button'
                    className={`passport-Button passport-Button_${provider}`}
                >
                    <span className='passport-Button-Content'>
                        <span className='passport-Button-After'>
                            <span className={`passport-Icon passport-Icon_social_${provider}`} />
                        </span>

                        <span className='passport-Button-Text'>{name}</span>
                    </span>
                </button>
            </li>
        );
    }
}

export class ExtendedSocialBlock extends Component {
    render() {
        const {providers, showInfo, onMouseDown, socialScope, startSocialAuth} = this.props;

        const big = providers.filter((item) => item.primary);
        const small = providers.filter((item) => !item.primary);

        return (
            <div>
                {Boolean(showInfo) && <h3 className='passport-Domik-Title'>{i18n('OneDomik.SocialBlock.title')}</h3>}

                <ul className='passport-Domik-SocialNetworks'>
                    {
                        // Object.keys(networks).map((item) =>
                        // <SocialBlockBigButton
                        //     onClick={() => startSocialAuth(networks[item].provider)}
                        //     key={networks[item].provider}
                        //     {...networks[item]}/>
                        // )
                    }
                    {big.map((item) => (
                        <SocialBlockBigButton
                            onClick={() =>
                                startSocialAuth({
                                    provider: item.data.code,
                                    scope: socialScope && socialScope[item.data.code]
                                })
                            }
                            onMouseDown={onMouseDown}
                            key={item.data.code}
                            {...networks[`social_${item.data.code}`]}
                        />
                    ))}
                    {small.map((item) => (
                        <li
                            data-metrics={`Начало соцавторизации: ${item.data.code}`}
                            onMouseDown={onMouseDown}
                            onClick={() =>
                                startSocialAuth({
                                    provider: item.data.code,
                                    scope: socialScope && socialScope[item.data.code]
                                })
                            }
                            key={item.data.code}
                            className={
                                // eslint-disable-next-line max-len
                                `passport-Domik-SocialNetworks-Item passport-Domik-SocialNetworks-Item_${item.data.code}`
                            }
                        >
                            <span className={`passport-Icon passport-Icon_social_${item.data.code}`} />
                        </li>
                    ))}
                </ul>
            </div>
        );
    }
}
export class SocialBlock extends Component {
    render() {
        const {method, providers, showInfo, socialScope, onMouseDown, startSocialAuth} = this.props;

        const preferred = [networks[method]];

        return (
            <div>
                {Boolean(showInfo) && <h3 className='passport-Domik-Title'>{i18n('OneDomik.SocialBlock.title')}</h3>}

                <ul className='passport-Domik-SocialNetworks'>
                    {method && preferred
                        ? preferred.map((item) => (
                              <SocialBlockBigButton
                                  onClick={() =>
                                      startSocialAuth({
                                          provider: item.provider,
                                          scope: socialScope && socialScope[item.provider]
                                      })
                                  }
                                  onMouseDown={onMouseDown}
                                  key={item.provider}
                                  {...item}
                              />
                          ))
                        : providers.map((item) => (
                              <li
                                  data-metrics={`Начало соцавторизации: ${item.data.code}`}
                                  onMouseDown={onMouseDown}
                                  onClick={() =>
                                      startSocialAuth({
                                          provider: item.data.code,
                                          scope: socialScope && socialScope[item.data.code]
                                      })
                                  }
                                  key={item.data.code}
                                  className={`passport-Domik-SocialNetworks-Item
                                    passport-Domik-SocialNetworks-Item_${item.data.code}`}
                              >
                                  <span className={`passport-Icon passport-Icon_social_${item.data.code}`} />
                              </li>
                          ))}
                </ul>
            </div>
        );
    }
}

SocialBlock.propTypes = {
    socialScope: PropTypes.object,
    method: PropTypes.string,
    showInfo: PropTypes.bool,
    providers: PropTypes.array,
    startSocialAuth: PropTypes.func,
    onMouseDown: PropTypes.func
};

ExtendedSocialBlock.propTypes = {
    socialScope: PropTypes.object,
    showInfo: PropTypes.bool,
    providers: PropTypes.array,
    startSocialAuth: PropTypes.func,
    onMouseDown: PropTypes.func
};

SocialBlockBigButton.propTypes = {
    name: PropTypes.string,
    onClick: PropTypes.func,
    onMouseDown: PropTypes.func,
    provider: PropTypes.string
};
