import React, {Component} from 'react';
import PropTypes from 'prop-types';

export class SwitchLink extends Component {
    render() {
        const {linkText, onClick, onMouseDown} = this.props;

        if (!linkText) {
            return null;
        }

        return (
            <span className='passport-Domik-Account-Item'>
                <span
                    onClick={onClick}
                    onMouseDown={onMouseDown}
                    data-metrics='Клик на Другой аккаунт'
                    className='passport-Domik-Account-Link passport-Domik-Link'
                >
                    {linkText}
                </span>
            </span>
        );
    }
}

export class SwitchModeToAddLink extends Component {
    constructor(props) {
        super(props);

        this.clickHandler = this.clickHandler.bind(this);
    }

    clickHandler(e) {
        e.preventDefault();
        this.props.onClick();
    }

    render() {
        const {linkText, onMouseDown, addUserUrl} = this.props;

        if (!linkText) {
            return null;
        }

        return (
            <li className='passport-AccountList-Item passport-false passport-false_adding'>
                <a
                    data-metrics='Клик на Другой аккаунт'
                    onMouseDown={onMouseDown}
                    onClick={this.clickHandler}
                    href={addUserUrl}
                    className='passport-AccountList-Link'
                >
                    <span className='passport-AccountList-Userpic passport-Userpic'>
                        <span className='passport-Icon passport-Icon_adding'>
                            <span className='passport-Icon-Helper1' />
                            <span className='passport-Icon-Helper2' />
                        </span>
                    </span>
                    <span className='passport-AccountList-Text'>{linkText}</span>
                </a>
            </li>
        );
    }
}

SwitchLink.propTypes = {
    linkText: PropTypes.string,
    onClick: PropTypes.func,
    onMouseDown: PropTypes.func
};

SwitchModeToAddLink.propTypes = {
    linkText: PropTypes.string,
    addUserUrl: PropTypes.string,
    onClick: PropTypes.func,
    onMouseDown: PropTypes.func
};
